/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.build;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.build.BuildServerDataProvider;
import pl.project13.maven.git.log.LoggerBridge;

public class TeamCityBuildServerData
extends BuildServerDataProvider {
    private final Properties teamcitySystemProperties = new Properties();

    TeamCityBuildServerData(@NotNull LoggerBridge log, @NotNull Map<String, String> env) {
        super(log, env);
        if (TeamCityBuildServerData.isActiveServer(env)) {
            try {
                this.teamcitySystemProperties.load(new FileInputStream(env.get("TEAMCITY_BUILD_PROPERTIES_FILE")));
            }
            catch (IOException | NullPointerException e) {
                log.error("Failed to retrieve Teamcity properties file", e);
            }
        }
    }

    public static boolean isActiveServer(@NotNull Map<String, String> env) {
        return env.containsKey("TEAMCITY_VERSION");
    }

    @Override
    void loadBuildNumber(@NotNull Properties properties) {
        String buildNumber = (String)this.env.get("BUILD_NUMBER");
        String buildNumberUnique = this.teamcitySystemProperties.getProperty("teamcity.build.id");
        this.put(properties, "build.number", buildNumber == null ? "" : buildNumber);
        this.put(properties, "build.number.unique", buildNumberUnique == null ? "" : buildNumberUnique);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = this.teamcitySystemProperties.getProperty("teamcity.build.branch");
        this.log.info("Using property file based branch name. teamcity.build.branch = {}", (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

