/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.TokenBuffer;

public class UnwrappedPropertyHandler {
    public static final String JSON_UNWRAPPED_NAME_PREFIX = "@JsonUnwrapped/";
    protected final List<SettableBeanProperty> _creatorProperties;
    protected final List<SettableBeanProperty> _properties;

    public UnwrappedPropertyHandler() {
        this._creatorProperties = new ArrayList<SettableBeanProperty>();
        this._properties = new ArrayList<SettableBeanProperty>();
    }

    protected UnwrappedPropertyHandler(List<SettableBeanProperty> creatorProps, List<SettableBeanProperty> props) {
        this._creatorProperties = creatorProps;
        this._properties = props;
    }

    public void addCreatorProperty(SettableBeanProperty property) {
        this._creatorProperties.add(property);
    }

    public void addProperty(SettableBeanProperty property) {
        this._properties.add(property);
    }

    public UnwrappedPropertyHandler renameAll(DeserializationContext ctxt, NameTransformer transformer) {
        return new UnwrappedPropertyHandler(this.renameProperties(ctxt, this._creatorProperties, transformer), this.renameProperties(ctxt, this._properties, transformer));
    }

    private List<SettableBeanProperty> renameProperties(DeserializationContext ctxt, Collection<SettableBeanProperty> properties, NameTransformer transformer) {
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(properties.size());
        for (SettableBeanProperty prop : properties) {
            if (prop == null) {
                newProps.add(null);
                continue;
            }
            newProps.add(prop.unwrapped(ctxt, transformer));
        }
        return newProps;
    }

    public PropertyValueBuffer processUnwrappedCreatorProperties(JsonParser originalParser, DeserializationContext ctxt, PropertyValueBuffer values, TokenBuffer buffered) {
        for (SettableBeanProperty prop : this._creatorProperties) {
            JsonParser p = buffered.asParserOnFirstToken(ctxt);
            values.assignParameter(prop, prop.deserialize(p, ctxt));
        }
        return values;
    }

    public Object processUnwrapped(JsonParser originalParser, DeserializationContext ctxt, Object bean, TokenBuffer buffered) {
        for (SettableBeanProperty prop : this._properties) {
            JsonParser p = buffered.asParserOnFirstToken(ctxt);
            prop.deserializeAndSet(p, ctxt, bean);
        }
        return bean;
    }

    public static PropertyName creatorParamName(int index) {
        return new PropertyName(JSON_UNWRAPPED_NAME_PREFIX + index);
    }
}

