/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.basicdataset.cv.classification.AbstractImageFolder;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.training.dataset.Dataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.JsonUtils;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class ImageNet
extends AbstractImageFolder {
    private String[] wordNetIds;
    private String[] classNames;
    private String[] classFull;
    private Path root;

    ImageNet(Builder builder) {
        super(builder);
        String usagePath = this.getUsagePath(builder.usage);
        this.root = Paths.get(this.mrl.getRepository().getBaseUri()).resolve(usagePath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String[] getWordNetIds() {
        return this.wordNetIds;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public String[] getClassFull() {
        return this.classFull;
    }

    public void prepare(Progress progress) throws IOException {
        if (!this.prepared) {
            this.mrl.prepare(null, progress);
            if (progress != null) {
                progress.reset("Preparing", 2L);
                progress.start(0L);
                this.listImages(this.root, Arrays.asList(this.wordNetIds));
                progress.end();
            } else {
                this.listImages(this.root, Arrays.asList(this.wordNetIds));
            }
            this.loadSynset();
            this.prepared = true;
        }
    }

    private void loadSynset() {
        ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
        try (InputStream classStream = cl.getResourceAsStream("imagenet/classes.json");){
            if (classStream == null) {
                throw new AssertionError((Object)"Missing imagenet/classes.json in jar resource");
            }
            InputStreamReader reader = new InputStreamReader(classStream, StandardCharsets.UTF_8);
            String[][] classes = (String[][])JsonUtils.GSON.fromJson((Reader)reader, String[][].class);
            this.wordNetIds = new String[classes.length];
            this.classNames = new String[classes.length];
            this.classFull = new String[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                this.wordNetIds[i] = classes[i][0];
                this.classNames[i] = classes[i][1];
                this.classFull[i] = classes[i][2];
                this.synset.add(this.wordNetIds[i] + ", " + this.classNames[i] + ", " + this.classFull[i]);
            }
        }
        catch (IOException e) {
            throw new AssertionError("Failed to read imagenet/classes.json file.", e);
        }
    }

    private String getUsagePath(Dataset.Usage usage) {
        switch (usage) {
            case TRAIN: {
                String usagePath = "train";
                return usagePath;
            }
            case VALIDATION: {
                String usagePath = "val";
                return usagePath;
            }
            case TEST: {
                throw new UnsupportedOperationException("Test data not available.");
            }
        }
        throw new UnsupportedOperationException("Data not available.");
    }

    @Override
    protected Path getImagePath(String key) {
        return this.root.resolve(key);
    }

    public static class Builder
    extends AbstractImageFolder.ImageFolderBuilder<Builder> {
        private Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder self() {
            return this;
        }

        public ImageNet build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new ImageNet(this);
        }
    }
}

