/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.Tensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public interface SparseTensor<T extends TType>
extends Tensor {
    public static <T extends TType> SparseTensor<T> of(TInt64 indices, T values, TInt64 denseShape) {
        if (indices.rank() != 2) {
            throw new IllegalArgumentException("Sparse indices must be a rank-2 tensor");
        }
        if (values.rank() != 1) {
            throw new IllegalArgumentException("Sparse values must be a rank-1 tensor");
        }
        if (denseShape.rank() != 1) {
            throw new IllegalArgumentException("Sparse shape must be a rank-1 tensor");
        }
        if (indices.shape().get(0) != values.shape().get(0)) {
            throw new IllegalArgumentException("Number of indices must be equal to the number of values [" + indices.shape().get(0) + " != " + values.shape().get(0) + "]");
        }
        if (indices.shape().get(1) != denseShape.shape().get(0)) {
            throw new IllegalArgumentException("Indices must have a coordinate for each dimensions of the tensor [" + indices.shape().get(1) + " != " + denseShape.shape().get(0) + "]");
        }
        TensorMapper<? extends TType> mapper = values.asRawTensor().typeInfo().mapper();
        try (PointerScope scope = new PointerScope();){
            scope.attach((Pointer)indices.asRawTensor().nativeHandle());
            scope.attach((Pointer)values.asRawTensor().nativeHandle());
            scope.attach((Pointer)denseShape.asRawTensor().nativeHandle());
            SparseTensor<? extends TType> sparseTensor = mapper.mapSparse(indices, values, denseShape, scope);
            return sparseTensor;
        }
    }

    @Override
    default public RawTensor asRawTensor() {
        throw new UnsupportedOperationException("Sparse tensors cannot be converted to a single raw tensor");
    }

    default public T asTypedTensor() {
        return (T)((TType)((Object)this));
    }

    public TInt64 indices();

    public T values();

    public TInt64 denseShape();
}

