/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StackPushV2", inputsClass=Inputs.class)
public final class StackPush<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "StackPushV2";
    private Output<T> output;

    public StackPush(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> StackPush<T> create(Scope scope, Operand<? extends TType> handle, Operand<T> elem, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "StackPush");
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(elem.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.swapMemory == null) continue;
                opBuilder.setAttr("swap_memory", opts.swapMemory);
            }
        }
        return new StackPush<T>(opBuilder.build());
    }

    public static Options swapMemory(Boolean swapMemory) {
        return new Options().swapMemory(swapMemory);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=StackPush.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<StackPush<T>> {
        public final Operand<? extends TType> handle;
        public final Operand<T> elem;
        public final DataType T;
        public final boolean swapMemory;

        public Inputs(GraphOperation op) {
            super(new StackPush(op), op, Arrays.asList("T", "swap_memory"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.elem = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.swapMemory = op.attributes().getAttrBool("swap_memory");
        }
    }

    public static class Options {
        private Boolean swapMemory;

        private Options() {
        }

        public Options swapMemory(Boolean swapMemory) {
            this.swapMemory = swapMemory;
            return this;
        }
    }
}

