/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="NearestNeighbors", inputsClass=Inputs.class)
public final class NearestNeighbors
extends RawOp {
    public static final String OP_NAME = "NearestNeighbors";
    private Output<TInt64> nearestCenterIndices;
    private Output<TFloat32> nearestCenterDistances;

    public NearestNeighbors(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.nearestCenterIndices = operation.output(outputIdx++);
        this.nearestCenterDistances = operation.output(outputIdx++);
    }

    public static NearestNeighbors create(Scope scope, Operand<TFloat32> points, Operand<TFloat32> centers, Operand<TInt64> k) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(points.asOutput());
        opBuilder.addInput(centers.asOutput());
        opBuilder.addInput(k.asOutput());
        return new NearestNeighbors(opBuilder.build());
    }

    public Output<TInt64> nearestCenterIndices() {
        return this.nearestCenterIndices;
    }

    public Output<TFloat32> nearestCenterDistances() {
        return this.nearestCenterDistances;
    }

    @OpInputsMetadata(outputsClass=NearestNeighbors.class)
    public static class Inputs
    extends RawOpInputs<NearestNeighbors> {
        public final Operand<TFloat32> points;
        public final Operand<TFloat32> centers;
        public final Operand<TInt64> k;

        public Inputs(GraphOperation op) {
            super(new NearestNeighbors(op), op, Arrays.asList(new String[0]));
            int inputIndex = 0;
            this.points = op.input(inputIndex++);
            this.centers = op.input(inputIndex++);
            this.k = op.input(inputIndex++);
        }
    }
}

