/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.math;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SobolSample", inputsClass=Inputs.class)
public final class SobolSample<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SobolSample";
    private Output<T> samples;

    public SobolSample(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.samples = operation.output(outputIdx++);
    }

    public static <T extends TNumber> SobolSample<T> create(Scope scope, Operand<TInt32> dim, Operand<TInt32> numResults, Operand<TInt32> skip, Class<T> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(dim.asOutput());
        opBuilder.addInput(numResults.asOutput());
        opBuilder.addInput(skip.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new SobolSample<T>(opBuilder.build());
    }

    public static SobolSample<TFloat32> create(Scope scope, Operand<TInt32> dim, Operand<TInt32> numResults, Operand<TInt32> skip) {
        return SobolSample.create(scope, dim, numResults, skip, TFloat32.class);
    }

    public Output<T> samples() {
        return this.samples;
    }

    @Override
    public Output<T> asOutput() {
        return this.samples;
    }

    @OpInputsMetadata(outputsClass=SobolSample.class)
    public static class Inputs
    extends RawOpInputs<SobolSample<?>> {
        public final Operand<TInt32> dim;
        public final Operand<TInt32> numResults;
        public final Operand<TInt32> skip;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new SobolSample(op), op, Arrays.asList("dtype"));
            int inputIndex = 0;
            this.dim = op.input(inputIndex++);
            this.numResults = op.input(inputIndex++);
            this.skip = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

