/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.controller;

import c.a.b.api.bo.FileUploadRspBO;
import c.a.b.service.FileConstant;
import c.a.b.service.MinioFileClient;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
public class FileOperUtil {
    private static final Logger log = LoggerFactory.getLogger(FileOperUtil.class);
    @Autowired
    private Environment env;
    @Autowired
    FileClient ossFileClient;
    @Autowired
    FileClient ftpFileClient;
    @Autowired
    MinioFileClient minioFileClient;
    @Autowired
    FileConstant fileConstant;

    @RequestMapping(value={"/download"})
    public void downloadFile(HttpServletResponse response, HttpServletRequest request) {
        String[] fileNameArray;
        String realPath;
        log.info("\u4e0b\u8f7d\u5f00\u59cb...");
        String toolType = request.getParameter("toolType");
        String fileEnvPath = request.getParameter("fileEnvPath");
        String fileName = request.getParameter("fileName");
        String newFileName = request.getParameter("newFileName");
        if (StringUtils.isEmpty((CharSequence)toolType)) {
            toolType = this.env.getProperty("defaultToolType");
            if (StringUtils.isEmpty((CharSequence)toolType)) {
                throw new ZTBusinessException("toolType\u672a\u914d\u7f6e\uff1adefaultToolType");
            }
            log.info("\u8d70\u9ed8\u8ba4\u5de5\u5177\u7c7b\u578b\u914d\u7f6e\uff1a" + toolType);
        }
        if (StringUtils.isNotEmpty((CharSequence)fileEnvPath)) {
            realPath = this.env.getProperty(fileEnvPath);
            if (null == realPath) {
                throw new ZTBusinessException("\u4e0b\u8f7d\u914d\u7f6e\u672a\u914d\u7f6e\uff1a" + fileEnvPath);
            }
        } else {
            realPath = "";
        }
        if ((fileNameArray = fileName.split(",")).length > 1) {
            ServletOutputStream res = null;
            ZipOutputStream zos = null;
            try {
                res = response.getOutputStream();
                zos = new ZipOutputStream((OutputStream)res);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/zip");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(newFileName, "UTF-8"));
                for (String fileNameTmp : fileNameArray) {
                    int index;
                    InputStream inputStream = null;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"OSS", (CharSequence)toolType)) {
                        inputStream = this.ossFileClient.downLoadToInputStream(realPath + fileNameTmp);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"FTP", (CharSequence)toolType)) {
                        inputStream = this.ftpFileClient.downLoadToInputStream(realPath + fileNameTmp);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"MINIO", (CharSequence)toolType)) {
                        inputStream = this.minioFileClient.downloadFileInputStream(realPath + fileNameTmp);
                    } else {
                        throw new ZTBusinessException("toolType\u672a\u77e5\u7c7b\u578b\uff0c\u4e0b\u8f7d\u5f02\u5e38");
                    }
                    String dir = System.getProperty("java.io.tmpdir");
                    fileNameTmp = dir + fileNameTmp;
                    File file = new File(fileNameTmp);
                    byte[] bytes = new byte[1024];
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    while ((index = inputStream.read(bytes)) != -1) {
                        fileOutputStream.write(bytes, 0, index);
                        fileOutputStream.flush();
                    }
                    this.doCompress(file, zos);
                    response.flushBuffer();
                    inputStream.close();
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
                throw new ZTBusinessException("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
            }
            finally {
                try {
                    if (zos != null) {
                        zos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        InputStream inputStream = null;
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)"OSS", (CharSequence)toolType)) {
                inputStream = this.ossFileClient.downLoadToInputStream(realPath + fileName);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"FTP", (CharSequence)toolType)) {
                inputStream = this.ftpFileClient.downLoadToInputStream(realPath + fileName);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"MINIO", (CharSequence)toolType)) {
                inputStream = this.minioFileClient.downloadFileInputStream(realPath + fileName);
            } else {
                throw new ZTBusinessException("toolType\u672a\u77e5\u7c7b\u578b\uff0c\u4e0b\u8f7d\u5f02\u5e38");
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("multipart/form-data;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(newFileName, "UTF-8"));
            byte[] buffer = new byte[1024];
            int L = 0;
            while ((L = inputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, L);
            }
            if (response.getOutputStream() != null) {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
            throw new ZTBusinessException("\u4e0b\u8f7d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("\u4e0b\u8f7d\u7ed3\u675f...");
    }

    @RequestMapping(value={"/uploadFile"})
    @BusiResponseBody
    public FileUploadRspBO uploadOssFile(HttpServletRequest request, @RequestParam(value="files", required=false) MultipartFile[] files) {
        log.info("\u4e0a\u4f20\u5f00\u59cb....");
        ArrayList uploadFiles = null;
        FileUploadRspBO rsp = new FileUploadRspBO();
        try {
            String fileRealPath;
            String toolType = request.getParameter("toolType");
            String fileEnvPath = request.getParameter("fileEnvPath");
            String needNewFileName = request.getParameter("needNewFileName");
            if (StringUtils.isEmpty((CharSequence)toolType)) {
                toolType = this.env.getProperty("defaultToolType");
                if (StringUtils.isEmpty((CharSequence)toolType)) {
                    throw new ZTBusinessException("toolType\u672a\u914d\u7f6e\uff1adefaultToolType");
                }
                log.info("\u8d70\u9ed8\u8ba4\u5de5\u5177\u7c7b\u578b\u914d\u7f6e\uff1a" + toolType);
            }
            log.debug("\u4e0a\u4f20\u65b9\u5f0f\uff1a" + toolType);
            if (StringUtils.isNotEmpty((CharSequence)fileEnvPath)) {
                fileRealPath = this.env.getProperty(fileEnvPath);
                if (null == fileRealPath) {
                    throw new ZTBusinessException("\u4e0b\u8f7d\u914d\u7f6e\u672a\u914d\u7f6e\uff1a" + fileRealPath);
                }
            } else {
                fileRealPath = "";
            }
            log.debug("\u4e0a\u4f20\u8def\u5f84\uff1a" + fileRealPath);
            uploadFiles = new ArrayList();
            for (MultipartFile file : files) {
                String fileName;
                String newFileName = fileName = file.getOriginalFilename();
                if (StringUtils.equalsIgnoreCase((CharSequence)"NEED", (CharSequence)needNewFileName)) {
                    newFileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
                }
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"OSS", (CharSequence)toolType)) {
                    log.info("oss\u4e0a\u4f20\u5f00\u59cb...");
                    this.ossFileClient.uploadFileByInputStream(fileRealPath, newFileName, inputStream);
                    log.info("oss\u4e0a\u4f20\u7ed3\u675f...");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"FTP", (CharSequence)toolType)) {
                    log.info("ftp\u4e0a\u4f20\u5f00\u59cb...");
                    this.ftpFileClient.uploadFileByInputStream(fileRealPath, newFileName, inputStream);
                    log.info("ftp\u4e0a\u4f20\u7ed3\u675f...");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"MINIO", (CharSequence)toolType)) {
                    log.info("minio\u4e0a\u4f20\u5f00\u59cb...");
                    this.minioFileClient.upLoadFileWithNewFileName(fileRealPath, newFileName, inputStream);
                    log.info("minio\u4e0a\u4f20\u7ed3\u675f...");
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fileName", fileName);
                map.put("newFileName", newFileName);
                map.put("fileEnvPath", fileEnvPath);
                map.put("toolType", toolType);
                uploadFiles.add(map);
            }
            rsp.setData(uploadFiles);
        }
        catch (ZTBusinessException e) {
            e.printStackTrace();
            log.error("\u4e0a\u4f20\u5931\u8d25" + (Object)((Object)e));
            rsp.setCode("1");
            rsp.setMessage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0a\u4f20\u5931\u8d25" + e);
            rsp.setCode("1");
            rsp.setMessage("\u5931\u8d25");
        }
        log.debug("rsp:" + rsp);
        log.info("\u4e0a\u4f20\u7ed3\u675f....");
        return rsp;
    }

    public void doCompress(File file, ZipOutputStream out) {
        if (file.exists()) {
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                int len = 0;
                while ((len = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e0b\u8f7d\u6253\u5305\u5f02\u5e38");
                throw new ZTBusinessException("\u4e0b\u8f7d\u6253\u5305\u5f02\u5e38");
            }
            finally {
                try {
                    if (null != out) {
                        out.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (null != out) {
                        out.closeEntry();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (null != out) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

