/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.DB1;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.PD1;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.PV1;
import ca.uhn.hl7v2.model.v25.segment.PV2;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ADT_A17
extends AbstractMessage {
    public ADT_A17(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public ADT_A17() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating ADT_A17 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV1 getPV1() {
        PV1 ret = null;
        try {
            ret = (PV1)this.get("PV1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV2 getPV2() {
        PV2 ret = null;
        try {
            ret = (PV2)this.get("PV2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB1() {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB1(int rep) {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDB1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DB1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public PID getPID2() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD12() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD12");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV1 getPV12() {
        PV1 ret = null;
        try {
            ret = (PV1)this.get("PV12");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV2 getPV22() {
        PV2 ret = null;
        try {
            ret = (PV2)this.get("PV22");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB12() {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB12");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB12(int rep) {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB12", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDB12Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DB12").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDB12(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB12", (Structure)structure, rep);
    }

    public DB1 insertDB12(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB12", rep);
    }

    public DB1 removeDB12(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB12", rep);
    }

    public OBX getOBX2() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX2(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX2", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBX2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX2(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX2", (Structure)structure, rep);
    }

    public OBX insertOBX2(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX2", rep);
    }

    public OBX removeOBX2(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX2", rep);
    }
}

