/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobNewOutputStream
extends OutputStream {
    private Blob largeObj;
    private byte[] _buf;
    private int bsize;
    private int bposition;
    private int blobposition;

    public BlobNewOutputStream(Blob largeObj, int position) {
        this.largeObj = largeObj;
        this.blobposition = position;
        this.bsize = 1024;
        this._buf = new byte[this.bsize];
        this.bposition = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIsClosed();
        try {
            if (this.bposition >= this.bsize) {
                this.largeObj.setBytes(this.blobposition, this._buf);
                this.blobposition += this._buf.length;
                this.bposition = 0;
            }
            this._buf[this.bposition++] = (byte)b;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(byte[] _buf, int off, int leng) throws IOException {
        this.checkIsClosed();
        try {
            if (this.bposition > 0) {
                this.flush();
            }
            if (off == 0 && leng == _buf.length) {
                this.largeObj.setBytes(this.blobposition, _buf);
                this.blobposition += _buf.length;
            } else {
                this.largeObj.setBytes(this.blobposition, _buf, off, leng);
                this.blobposition += leng;
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkIsClosed();
        try {
            if (this.bposition > 0) {
                this.largeObj.setBytes(this.blobposition, this._buf, 0, this.bposition);
                this.blobposition += this.bposition;
            }
            this.bposition = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.largeObj != null) {
            this.flush();
            this.largeObj = null;
        }
    }

    private void checkIsClosed() throws IOException {
        if (this.largeObj == null) {
            throw new IOException("BlobNewOutputStream is closed");
        }
    }
}

