/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.agent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.agent.bean.Agent;
import com.riversoft.weixin.qy.agent.bean.WritableAgent;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agents {
    private static Logger logger = LoggerFactory.getLogger(Agents.class);
    private WxClient wxClient;

    public static Agents defaultAgents() {
        return Agents.with(CorpSetting.defaultSettings());
    }

    public static Agents with(CorpSetting corpSetting) {
        Agents agents = new Agents();
        agents.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return agents;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public List<Agent> list() {
        String url = WxEndpoint.get("url.agent.list");
        String content = this.wxClient.get(url);
        logger.debug("list agents: {}", (Object)content);
        AgentsList agentsList = (AgentsList)JsonMapper.nonEmptyMapper().fromJson(content, AgentsList.class);
        return agentsList.getAgents();
    }

    public Agent get(int id) {
        String url = WxEndpoint.get("url.agent.get");
        String agent = this.wxClient.get(String.format(url, id));
        logger.debug("get agent: {}", (Object)agent);
        return (Agent)JsonMapper.nonEmptyMapper().fromJson(agent, Agent.class);
    }

    public void update(Agent agent) {
        WritableAgent writableAgent = new WritableAgent();
        writableAgent.setAgentId(agent.getAgentId());
        writableAgent.setName(agent.getName());
        writableAgent.setDescription(agent.getDescription());
        writableAgent.setReportLocationFlag(agent.getReportLocationFlag());
        writableAgent.setReportUserChange(agent.isReportUserChange());
        writableAgent.setReportUserEnter(agent.isReportUserEnter());
        writableAgent.setLogoMediaId(agent.getLogoMediaId());
        writableAgent.setRedirectDomain(agent.getRedirectDomain());
        String url = WxEndpoint.get("url.agent.set");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)writableAgent);
        logger.info("update agent: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public static class AgentsList {
        @JsonProperty(value="agentlist")
        private List<Agent> agents;

        public List<Agent> getAgents() {
            return this.agents;
        }

        public void setAgents(List<Agent> agents) {
            this.agents = agents;
        }
    }
}

