/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.base;

import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpSetting {
    private static Logger logger = LoggerFactory.getLogger(CorpSetting.class);
    private static CorpSetting defaultSetting = null;
    private String corpId;
    private String corpSecret;
    private String tokenHolderClass;

    public CorpSetting() {
    }

    public CorpSetting(String corpId, String corpSecret) {
        this.corpId = corpId;
        this.corpSecret = corpSecret;
    }

    public static void setDefault(CorpSetting corpSetting) {
        defaultSetting = corpSetting;
    }

    public static CorpSetting defaultSettings() {
        if (defaultSetting == null) {
            CorpSetting.loadFromSystemProperties();
        }
        if (defaultSetting == null) {
            CorpSetting.loadFromClasspath();
        }
        if (defaultSetting == null) {
            throw new WxRuntimeException(999, "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u8bbe\u7f6e\u7f3a\u7701\u7684corpId\u548ccorpSecret,\u8bf7\u4f7f\u7528setDefault\u65b9\u6cd5\u6216\u8005\u5728classpath\u4e0b\u9762\u521b\u5efawx-qy-settings.xml\u6587\u4ef6.");
        }
        return defaultSetting;
    }

    private static void loadFromSystemProperties() {
        if (System.getProperties().contains("qyconfig")) {
            logger.info("loading qy configuration from system properties...");
            String xml = System.getProperties().getProperty("qyconfig", "");
            logger.info("qyconfig: {}", (Object)xml);
            if (xml == null || "".equals(xml)) {
                return;
            }
            try {
                CorpSetting defaultSettings;
                defaultSetting = defaultSettings = (CorpSetting)XmlObjectMapper.defaultMapper().fromXml(xml, CorpSetting.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadFromClasspath() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-qy-settings-test.xml");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("wx-qy-settings.xml");
            }
            if (inputStream != null) {
                CorpSetting defaultSettings;
                String xml = IOUtils.toString((InputStream)inputStream);
                defaultSetting = defaultSettings = (CorpSetting)XmlObjectMapper.defaultMapper().fromXml(xml, CorpSetting.class);
            }
        }
        catch (IOException e) {
            logger.error("read settings from wx-qy-settings-test.xml or wx-qy-settings.xml failed:", (Throwable)e);
        }
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getCorpSecret() {
        return this.corpSecret;
    }

    public void setCorpSecret(String corpSecret) {
        this.corpSecret = corpSecret;
    }

    public String getTokenHolderClass() {
        return this.tokenHolderClass;
    }

    public void setTokenHolderClass(String tokenHolderClass) {
        this.tokenHolderClass = tokenHolderClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorpSetting that = (CorpSetting)o;
        if (!this.corpId.equals(that.corpId)) {
            return false;
        }
        return this.corpSecret.equals(that.corpSecret);
    }

    public int hashCode() {
        int result = this.corpId.hashCode();
        result = 31 * result + this.corpSecret.hashCode();
        return result;
    }
}

