/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.contact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.contact.Users;
import com.riversoft.weixin.qy.contact.department.Department;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Departments {
    private static Logger logger = LoggerFactory.getLogger(Users.class);
    private WxClient wxClient;

    public static Departments defaultDepartments() {
        return Departments.with(CorpSetting.defaultSettings());
    }

    public static Departments with(CorpSetting corpSetting) {
        Departments departments = new Departments();
        departments.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return departments;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Department get(int id) {
        String url = WxEndpoint.get("url.department.get");
        String user = this.wxClient.get(String.format(url, id));
        logger.debug("get department: {}", (Object)user);
        return (Department)JsonMapper.nonEmptyMapper().fromJson(user, Department.class);
    }

    public void create(Department department) {
        String url = WxEndpoint.get("url.department.create");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)department);
        logger.debug("create department: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void update(Department department) {
        String url = WxEndpoint.get("url.department.update");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)department);
        logger.debug("update department: {}", (Object)department);
        this.wxClient.post(url, json);
    }

    public void delete(int id) {
        String url = WxEndpoint.get("url.department.delete");
        logger.debug("delete department: {}", (Object)id);
        this.wxClient.get(String.format(url, id));
    }

    public List<Department> list() {
        String url = WxEndpoint.get("url.department.list.all");
        String response = this.wxClient.get(url);
        logger.debug("list all departments: {}", (Object)response);
        DepartmentList departmentList = (DepartmentList)JsonMapper.nonEmptyMapper().fromJson(response, DepartmentList.class);
        return departmentList.getDepartments();
    }

    public List<Department> list(int id) {
        String url = WxEndpoint.get("url.department.list");
        String response = this.wxClient.get(String.format(url, id));
        logger.debug("list departments: {}", (Object)response);
        DepartmentList departmentList = (DepartmentList)JsonMapper.nonEmptyMapper().fromJson(response, DepartmentList.class);
        return departmentList.getDepartments();
    }

    public static class DepartmentList {
        private List<Department> departments;

        @JsonProperty(value="department")
        @JsonUnwrapped
        public List<Department> getDepartments() {
            return this.departments;
        }

        public void setDepartments(List<Department> departments) {
            this.departments = departments;
        }
    }
}

