/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.contact;

import com.google.common.base.Joiner;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.contact.job.JobResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jobs {
    private static Logger logger = LoggerFactory.getLogger(Jobs.class);
    private WxClient wxClient;

    public static Jobs defaultJobs() {
        return Jobs.with(CorpSetting.defaultSettings());
    }

    public static Jobs with(CorpSetting corpSetting) {
        Jobs jobs = new Jobs();
        jobs.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return jobs;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String invite(List<String> users, List<Integer> departments, List<Integer> tags) {
        HashMap<String, String> maps = new HashMap<String, String>();
        if (!this.isEmpty(users)) {
            maps.put("touser", Joiner.on((String)"|").join(users));
        }
        if (!this.isEmpty(departments)) {
            maps.put("toparty", Joiner.on((String)"|").join(departments));
        }
        if (!this.isEmpty(tags)) {
            maps.put("toparty", Joiner.on((String)"|").join(tags));
        }
        String url = WxEndpoint.get("url.job.users.invite");
        String json = JsonMapper.defaultMapper().toJson(maps);
        logger.debug("invite users: {}", (Object)json);
        return this.submit(url, json);
    }

    private boolean isEmpty(List users) {
        return users == null || users.isEmpty();
    }

    public JobResult getResult(String id) {
        String url = WxEndpoint.get("url.job.result");
        String result = this.wxClient.get(String.format(url, id));
        logger.debug("get job result: {}", (Object)result);
        return (JobResult)JsonMapper.nonEmptyMapper().fromJson(result, JobResult.class);
    }

    public String syncUsers(File file) {
        String mediaId = this.mediaUpload(file);
        return this.syncUsers(mediaId);
    }

    public String syncUsers(String mediaId) {
        String json = String.format("{\"media_id\":\"%s\"}", mediaId);
        String url = WxEndpoint.get("url.job.users.sync");
        logger.debug("sync users: {}", (Object)json);
        return this.submit(url, json);
    }

    public String replaceUsers(File file) {
        String mediaId = this.mediaUpload(file);
        return this.replaceUsers(mediaId);
    }

    public String replaceUsers(String mediaId) {
        String json = String.format("{\"media_id\":\"%s\"}", mediaId);
        String url = WxEndpoint.get("url.job.users.replace");
        logger.debug("replace users: {}", (Object)json);
        return this.submit(url, json);
    }

    public String replaceDepartments(File file) {
        String mediaId = this.mediaUpload(file);
        return this.replaceDepartments(mediaId);
    }

    public String replaceDepartments(String mediaId) {
        String json = String.format("{\"media_id\":\"%s\"}", mediaId);
        String url = WxEndpoint.get("url.job.departments.replace");
        logger.debug("replace department: {}", (Object)json);
        return this.submit(url, json);
    }

    private String submit(String url, String json) {
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("jobid")) {
            return result.get("jobid").toString();
        }
        throw new WxRuntimeException(999, "cannot get job id.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String mediaUpload(File file) {
        String url = WxEndpoint.get("url.media.upload");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String response = this.wxClient.post(String.format(url, "file"), (InputStream)fileInputStream, file.getName());
            HashMap result = JsonMapper.defaultMapper().json2Map(response);
            if (result.containsKey("media_id")) {
                String string = result.get("media_id").toString();
                return string;
            }
            logger.warn("media upload failed: {}", (Object)response);
            throw new WxRuntimeException(998, response);
        }
        catch (Exception e) {
            logger.error("media upload failed.", (Throwable)e);
            throw new WxRuntimeException(998, "media upload failed" + e.getMessage());
        }
    }
}

