/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.contact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.contact.Users;
import com.riversoft.weixin.qy.contact.tag.Tag;
import com.riversoft.weixin.qy.contact.tag.TagUsers;
import com.riversoft.weixin.qy.contact.tag.TagUsersResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tags {
    private static Logger logger = LoggerFactory.getLogger(Users.class);
    private WxClient wxClient;

    public static Tags defaultTags() {
        return Tags.with(CorpSetting.defaultSettings());
    }

    public static Tags with(CorpSetting corpSetting) {
        Tags tags = new Tags();
        tags.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return tags;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void create(Tag tag) {
        String url = WxEndpoint.get("url.tag.create");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)tag);
        logger.debug("create tag: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void update(Tag tag) {
        String url = WxEndpoint.get("url.tag.update");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)tag);
        logger.debug("update tag: {}", (Object)tag);
        this.wxClient.post(url, json);
    }

    public void delete(int id) {
        String url = WxEndpoint.get("url.tag.delete");
        logger.debug("delete tag: {}", (Object)id);
        this.wxClient.get(String.format(url, id));
    }

    public List<Tag> list() {
        String url = WxEndpoint.get("url.tag.list");
        String response = this.wxClient.get(url);
        TagList tagList = (TagList)JsonMapper.defaultMapper().fromJson(response, TagList.class);
        return tagList.getTags();
    }

    public TagUsersResult addUsers(int tagId, List<String> users, List<Integer> departments) {
        String url = WxEndpoint.get("url.tag.user.add");
        TagUsersWrapper tagUsers = new TagUsersWrapper();
        tagUsers.setTagId(tagId);
        tagUsers.setUsers(users);
        tagUsers.setDepartments(departments);
        String json = JsonMapper.nonEmptyMapper().toJson((Object)tagUsers);
        logger.debug("add users to tag: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        return (TagUsersResult)JsonMapper.nonEmptyMapper().fromJson(response, TagUsersResult.class);
    }

    public TagUsersResult deleteUsers(int tagId, List<String> users, List<Integer> departments) {
        String url = WxEndpoint.get("url.tag.user.delete");
        TagUsersWrapper tagUsers = new TagUsersWrapper();
        tagUsers.setTagId(tagId);
        tagUsers.setUsers(users);
        tagUsers.setDepartments(departments);
        String json = JsonMapper.nonEmptyMapper().toJson((Object)tagUsers);
        logger.debug("delete users from tag: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        return (TagUsersResult)JsonMapper.nonEmptyMapper().fromJson(response, TagUsersResult.class);
    }

    public TagUsers getUsers(int id) {
        String url = WxEndpoint.get("url.tag.user.get");
        logger.debug("get tag user: {}", (Object)id);
        String response = this.wxClient.get(String.format(url, id));
        TagUsers tagUsers = (TagUsers)JsonMapper.defaultMapper().fromJson(response, TagUsers.class);
        tagUsers.setTagId(id);
        return tagUsers;
    }

    public static class TagUsersWrapper {
        @JsonProperty(value="tagid")
        private int tagId;
        @JsonProperty(value="userlist")
        private List<String> users;
        @JsonProperty(value="partylist")
        private List<Integer> departments;

        public int getTagId() {
            return this.tagId;
        }

        public void setTagId(int tagId) {
            this.tagId = tagId;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            this.users = users;
        }

        public List<Integer> getDepartments() {
            return this.departments;
        }

        public void setDepartments(List<Integer> departments) {
            this.departments = departments;
        }
    }

    public static class TagList {
        @JsonProperty(value="taglist")
        private List<Tag> tags;

        public List<Tag> getTags() {
            return this.tags;
        }

        public void setTags(List<Tag> tags) {
            this.tags = tags;
        }
    }
}

