/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.contact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.contact.user.CreateUser;
import com.riversoft.weixin.qy.contact.user.Invitation;
import com.riversoft.weixin.qy.contact.user.ReadUser;
import com.riversoft.weixin.qy.contact.user.SimpleUser;
import com.riversoft.weixin.qy.contact.user.UpdateUser;
import com.riversoft.weixin.qy.contact.user.UserStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Users {
    private static Logger logger = LoggerFactory.getLogger(Users.class);
    private WxClient wxClient;

    public static Users defaultUsers() {
        return Users.with(CorpSetting.defaultSettings());
    }

    public static Users with(CorpSetting corpSetting) {
        Users users = new Users();
        users.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return users;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public ReadUser get(String uid) {
        String url = WxEndpoint.get("url.user.get");
        String user = this.wxClient.get(String.format(url, uid));
        logger.debug("get user: {}", (Object)user);
        return (ReadUser)JsonMapper.nonEmptyMapper().fromJson(user, ReadUser.class);
    }

    public void create(CreateUser user) {
        String url = WxEndpoint.get("url.user.create");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)user);
        logger.debug("create user: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public void update(UpdateUser user) {
        String url = WxEndpoint.get("url.user.update");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)user);
        logger.debug("update user: {}", (Object)user);
        this.wxClient.post(url, json);
    }

    public void delete(String uid) {
        String url = WxEndpoint.get("url.user.delete");
        logger.debug("delete user: {}", (Object)uid);
        this.wxClient.get(String.format(url, uid));
    }

    public List<SimpleUser> simpleList(int department, boolean fetchChild, Set<UserStatus> statusSet) {
        int status = 0;
        if (statusSet != null && statusSet.size() > 0) {
            for (UserStatus userStatus : statusSet) {
                status += userStatus.getStatus();
            }
        }
        String url = WxEndpoint.get("url.user.simple.list");
        String user = this.wxClient.get(String.format(url, department, fetchChild ? "1" : "0", status));
        logger.debug("list user: {}", (Object)user);
        SimpleUserList simpleUserList = (SimpleUserList)JsonMapper.nonEmptyMapper().fromJson(user, SimpleUserList.class);
        return simpleUserList.getUsers();
    }

    public List<SimpleUser> simpleList(int department) {
        return this.simpleList(department, true, null);
    }

    public List<ReadUser> list(int department, boolean fetchChild, Set<UserStatus> statusSet) {
        int status = 0;
        if (statusSet != null && statusSet.size() > 0) {
            for (UserStatus userStatus : statusSet) {
                status += userStatus.getStatus();
            }
        }
        String url = WxEndpoint.get("url.user.list");
        String user = this.wxClient.get(String.format(url, department, fetchChild ? "1" : "0", status));
        logger.debug("list user: {}", (Object)user);
        ReadUserList readUserList = (ReadUserList)JsonMapper.nonEmptyMapper().fromJson(user, ReadUserList.class);
        return readUserList.getUsers();
    }

    public List<ReadUser> list() {
        return this.list(1, true, null);
    }

    public List<ReadUser> list(int department) {
        return this.list(department, true, null);
    }

    public void delete(List<String> users) {
        String url = WxEndpoint.get("url.user.batch.delete");
        String json = String.format("{\"useridlist\":\"%s\"}", JsonMapper.defaultMapper().toJson(users));
        logger.debug("delete users: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    @Deprecated
    public Invitation invite(String uid) {
        String url = WxEndpoint.get("url.user.invite");
        String json = "{\"userid\":\"%s\"}";
        logger.debug("invite user: {}", (Object)String.format(json, uid));
        try {
            String response = this.wxClient.post(url, String.format(json, uid));
            HashMap result = JsonMapper.defaultMapper().json2Map(response);
            if (result.containsKey("type")) {
                return Invitation.format(Integer.valueOf(result.get("type").toString()));
            }
            return Invitation.FAILED;
        }
        catch (Exception e) {
            if (e instanceof WxRuntimeException) {
                WxRuntimeException wxRuntimeException = (WxRuntimeException)e;
                if (60119 == wxRuntimeException.getCode()) {
                    return Invitation.ALREADY_FOLLOWED;
                }
                if (45025 == wxRuntimeException.getCode()) {
                    return Invitation.ALREADY_INVITED;
                }
            }
            return Invitation.FAILED;
        }
    }

    public static class SimpleUserList {
        @JsonProperty(value="userlist")
        @JsonUnwrapped
        private List<SimpleUser> users;

        public List<SimpleUser> getUsers() {
            return this.users;
        }

        public void setUsers(List<SimpleUser> users) {
            this.users = users;
        }
    }

    public static class ReadUserList {
        @JsonProperty(value="userlist")
        @JsonUnwrapped
        private List<ReadUser> users;

        public List<ReadUser> getUsers() {
            return this.users;
        }

        public void setUsers(List<ReadUser> users) {
            this.users = users;
        }
    }
}

