/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.jsapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.decrypt.AesException;
import com.riversoft.weixin.common.decrypt.SHA1;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.jsapi.JsAPISignature;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.common.util.RandomStringGenerator;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsAPIs {
    private static Logger logger = LoggerFactory.getLogger(JsAPIs.class);
    private APITicket jsAPITicket;
    private APITicket jsAPIGroupTicket;
    private WxClient wxClient;

    public static JsAPIs defaultJsAPIs() {
        return JsAPIs.with(CorpSetting.defaultSettings());
    }

    public static JsAPIs with(CorpSetting corpSetting) {
        JsAPIs jsAPIs = new JsAPIs();
        jsAPIs.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return jsAPIs;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    private synchronized void getJsAPITicket() {
        if (this.jsAPITicket == null || this.jsAPITicket.expired()) {
            String url = WxEndpoint.get("url.jsapi.ticket.get");
            String response = this.wxClient.get(url);
            this.jsAPITicket = APITicket.fromJson(response);
        }
    }

    private synchronized void getJsAPIGroupTicket() {
        if (this.jsAPIGroupTicket == null || this.jsAPIGroupTicket.expired()) {
            String url = WxEndpoint.get("url.jsapi.ticket.group.get");
            String response = this.wxClient.get(url);
            this.jsAPIGroupTicket = APITicket.fromJson(response);
        }
    }

    public JsAPISignature createJsAPISignature(String url) {
        if (this.jsAPITicket == null || this.jsAPITicket.expired()) {
            this.getJsAPITicket();
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String ticket = this.jsAPITicket.getTicket();
        try {
            String signature = SHA1.getSHA1((String)("jsapi_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timestamp + "&url=" + url));
            JsAPISignature jsAPISignature = new JsAPISignature();
            jsAPISignature.setAppId(this.wxClient.getClientId());
            jsAPISignature.setNonce(nonce);
            jsAPISignature.setTimestamp(timestamp);
            jsAPISignature.setSignature(signature);
            jsAPISignature.setUrl(url);
            return jsAPISignature;
        }
        catch (AesException e) {
            logger.error("createJsAPISignature failed", (Throwable)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    public JsAPISignature createJsAPIGroupSignature(String url) {
        if (this.jsAPIGroupTicket == null || this.jsAPIGroupTicket.expired()) {
            this.getJsAPIGroupTicket();
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = RandomStringGenerator.getRandomStringByLength((int)16);
        String ticket = this.jsAPIGroupTicket.getTicket();
        try {
            String signature = SHA1.getSHA1((String)("group_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timestamp + "&url=" + url));
            JsAPISignature jsAPISignature = new JsAPISignature();
            jsAPISignature.setAppId(this.wxClient.getClientId());
            jsAPISignature.setNonce(nonce);
            jsAPISignature.setTimestamp(timestamp);
            jsAPISignature.setSignature(signature);
            jsAPISignature.setUrl(url);
            jsAPISignature.setGroupId(this.jsAPIGroupTicket.getGroupId());
            return jsAPISignature;
        }
        catch (AesException e) {
            logger.error("createJsAPIGroupSignature failed", (Throwable)e);
            throw new WxRuntimeException(999, e.getMessage());
        }
    }

    public static class APITicket {
        @JsonProperty(value="group_id")
        private String groupId;
        private String ticket;
        @JsonProperty(value="expires_in")
        private long expiresIn;
        private long expiresTill;

        public static APITicket fromJson(String json) {
            return (APITicket)JsonMapper.defaultMapper().fromJson(json, APITicket.class);
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getTicket() {
            return this.ticket;
        }

        public void setTicket(String ticket) {
            this.ticket = ticket;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            this.expiresTill = System.currentTimeMillis() + expiresIn * 1000L - 60000L;
        }

        public long getExpiresTill() {
            return this.expiresTill;
        }

        public boolean expired() {
            return System.currentTimeMillis() > this.expiresTill;
        }
    }
}

