/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.media.MediaType;
import com.riversoft.weixin.common.media.MpNews;
import com.riversoft.weixin.common.util.DateDeserializer;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.media.bean.Counts;
import com.riversoft.weixin.qy.media.bean.MaterialPagination;
import com.riversoft.weixin.qy.media.bean.MpNewsPagination;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Materials {
    private static Logger logger = LoggerFactory.getLogger(Materials.class);
    private WxClient wxClient;

    public static Materials defaultMaterials() {
        return Materials.with(CorpSetting.defaultSettings());
    }

    public static Materials with(CorpSetting corpSetting) {
        Materials materials = new Materials();
        materials.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return materials;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String addMpNews(int agent, MpNews mpNews) {
        String url = WxEndpoint.get("url.material.mpnews.add");
        HashMap<String, Integer> request = new HashMap<String, Integer>();
        request.put("agentid", agent);
        request.put("mpnews", (Integer)mpNews);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.info("add mpnews: {}", (Object)json);
        String response = this.wxClient.post(url, json);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return result.get("media_id").toString();
        }
        logger.warn("mpnews add failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public void updateMpNews(int agent, String mediaId, MpNews mpNews) {
        String url = WxEndpoint.get("url.material.mpnews.update");
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("agentid", agent);
        request.put("mpnews", mpNews);
        request.put("mediaId", mediaId);
        String json = JsonMapper.nonEmptyMapper().toJson(request);
        logger.info("update mpnews: {}", (Object)json);
        this.wxClient.post(url, json);
    }

    public MpNews getMpNews(int agent, String mediaId) {
        String url = WxEndpoint.get("url.material.mpnews.get");
        String response = this.wxClient.get(String.format(url, agent, mediaId));
        GetMpNewsResponse getMpNewsResponse = (GetMpNewsResponse)JsonMapper.defaultMapper().fromJson(response, GetMpNewsResponse.class);
        if (getMpNewsResponse != null) {
            return getMpNewsResponse.getMpNews();
        }
        return null;
    }

    public void deleteMpNews(int agentId, String mediaId) {
        this.delete(agentId, mediaId);
    }

    public String upload(int agent, MediaType type, InputStream inputStream, String fileName) {
        String url = WxEndpoint.get("url.material.binary.upload");
        String response = this.wxClient.post(String.format(url, agent, type.name()), inputStream, fileName);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("errcode") && "0".equals(result.get("errcode").toString())) {
            return result.get("media_id").toString();
        }
        logger.warn("material upload failed: {}", (Object)response);
        throw new WxRuntimeException(998, response);
    }

    public File download(int agent, String mediaId) {
        return this.wxClient.download(String.format(WxEndpoint.get("url.material.binary.get"), agent, mediaId));
    }

    public void delete(int agent, String mediaId) {
        String response = this.wxClient.get(String.format(WxEndpoint.get("url.material.delete"), agent, mediaId));
        logger.info("material delete result: {}", (Object)response);
    }

    public String addMpNewsImage(InputStream inputStream, String fileName) {
        String url = WxEndpoint.get("url.mpnews.image.upload");
        String response = this.wxClient.post(url, inputStream, fileName);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("url")) {
            return result.get("url").toString();
        }
        logger.warn("mpnews image upload failed: {}", (Object)response);
        throw new WxRuntimeException(999, response);
    }

    public Counts count(int agent) {
        String response = this.wxClient.get(String.format(WxEndpoint.get("url.material.count"), agent));
        return (Counts)JsonMapper.defaultMapper().fromJson(response, Counts.class);
    }

    public MaterialPagination list(int agentId, MediaType type, int offset, int size) {
        String request = "{\"type\":\"%s\",\"agentid\":%s,\"offset\":%s,\"count\":%s}";
        String url = WxEndpoint.get("url.material.list");
        String response = this.wxClient.post(url, String.format(request, type.name(), agentId, offset, size));
        return this.toMaterialSearchResult((QyMaterialSearchResult)JsonMapper.defaultMapper().fromJson(response, QyMaterialSearchResult.class));
    }

    public MpNewsPagination listMpNews(int agentId, int offset, int size) {
        String request = "{\"type\":\"%s\",\"agentid\":%s,\"offset\":%s,\"count\":%s}";
        String url = WxEndpoint.get("url.material.list");
        String response = this.wxClient.post(url, String.format(request, MediaType.mpnews.name(), agentId, offset, size));
        logger.debug("list mpnews: {}", (Object)response);
        return (MpNewsPagination)JsonMapper.defaultMapper().fromJson(response, MpNewsPagination.class);
    }

    private MaterialPagination toMaterialSearchResult(QyMaterialSearchResult qyMaterialSearchResult) {
        MaterialPagination result = new MaterialPagination();
        result.setTotalCount(qyMaterialSearchResult.getTotalCount());
        result.setCurrentCount(qyMaterialSearchResult.getCurrentCount());
        List<QyMaterialSearchResult.Material> qyItems = qyMaterialSearchResult.getItems();
        ArrayList<MaterialPagination.Material> items = new ArrayList<MaterialPagination.Material>();
        for (QyMaterialSearchResult.Material qyItem : qyItems) {
            MaterialPagination.Material item = new MaterialPagination.Material();
            item.setFileName(qyItem.getFileName());
            item.setMediaId(qyItem.getMediaId());
            item.setUpdateTime(qyItem.updateTime);
            items.add(item);
        }
        result.setItems(items);
        return result;
    }

    public static class GetMpNewsResponse {
        private String type;
        @JsonProperty(value="mpnews")
        private MpNews mpNews;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public MpNews getMpNews() {
            return this.mpNews;
        }

        public void setMpNews(MpNews mpNews) {
            this.mpNews = mpNews;
        }
    }

    public static class QyMaterialSearchResult {
        private MediaType type;
        @JsonProperty(value="total_count")
        private int totalCount;
        @JsonProperty(value="item_count")
        private int currentCount;
        @JsonProperty(value="itemlist")
        @JsonUnwrapped
        private List<Material> items;

        public MediaType getType() {
            return this.type;
        }

        public void setType(MediaType type) {
            this.type = type;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(int currentCount) {
            this.currentCount = currentCount;
        }

        public List<Material> getItems() {
            return this.items;
        }

        public void setItems(List<Material> items) {
            this.items = items;
        }

        public static class Material {
            @JsonProperty(value="media_id")
            private String mediaId;
            @JsonProperty(value="filename")
            private String fileName;
            @JsonProperty(value="update_time")
            @JsonDeserialize(using=DateDeserializer.class)
            private Date updateTime;

            public String getMediaId() {
                return this.mediaId;
            }

            public void setMediaId(String mediaId) {
                this.mediaId = mediaId;
            }

            public String getFileName() {
                return this.fileName;
            }

            public void setFileName(String fileName) {
                this.fileName = fileName;
            }

            public Date getUpdateTime() {
                return this.updateTime;
            }

            public void setUpdateTime(Date updateTime) {
                this.updateTime = updateTime;
            }
        }
    }
}

