/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.media;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.media.MediaType;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Medias {
    private static Logger logger = LoggerFactory.getLogger(Medias.class);
    private WxClient wxClient;

    public static Medias defaultMedias() {
        return Medias.with(CorpSetting.defaultSettings());
    }

    public static Medias with(CorpSetting corpSetting) {
        Medias medias = new Medias();
        medias.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return medias;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public String upload(MediaType type, InputStream inputStream, String fileName) {
        if (type == MediaType.mpnews) {
            throw new WxRuntimeException(999, "unsupported media type: " + type.name());
        }
        String url = WxEndpoint.get("url.media.upload");
        String response = this.wxClient.post(String.format(url, type.name()), inputStream, fileName);
        HashMap result = JsonMapper.defaultMapper().json2Map(response);
        if (result.containsKey("media_id")) {
            return result.get("media_id").toString();
        }
        logger.warn("media upload failed: {}", (Object)response);
        throw new WxRuntimeException(998, response);
    }

    public File download(String mediaId) {
        return this.wxClient.download(String.format(WxEndpoint.get("url.media.get"), mediaId));
    }
}

