/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.menu;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.menu.Menu;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Menus {
    private static Logger logger = LoggerFactory.getLogger(Menus.class);
    private WxClient wxClient;

    public static Menus defaultMenus() {
        return Menus.with(CorpSetting.defaultSettings());
    }

    public static Menus with(CorpSetting corpSetting) {
        Menus menus = new Menus();
        menus.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return menus;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void create(int agent, Menu menu) {
        String url = WxEndpoint.get("url.menu.create");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)menu);
        logger.info("update menu: {}", (Object)json);
        this.wxClient.post(String.format(url, agent), json);
    }

    public void delete(int agent) {
        String url = WxEndpoint.get("url.menu.delete");
        this.wxClient.get(String.format(url, agent));
    }

    public Menu get(int agent) {
        String url = WxEndpoint.get("url.menu.get");
        String content = this.wxClient.get(String.format(url, agent));
        logger.debug("get menu: {}", (Object)content);
        MenuWrapper menuWrapper = (MenuWrapper)JsonMapper.nonEmptyMapper().fromJson(content, MenuWrapper.class);
        return menuWrapper.getMenu();
    }

    public static class MenuWrapper
    implements Serializable {
        private Menu menu;

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            this.menu = menu;
        }
    }
}

