/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.message;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.message.json.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages {
    private static Logger logger = LoggerFactory.getLogger(Messages.class);
    private WxClient wxClient;

    public static Messages defaultMessages() {
        return Messages.with(CorpSetting.defaultSettings());
    }

    public static Messages with(CorpSetting corpSetting) {
        Messages messages = new Messages();
        messages.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return messages;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void send(JsonMessage message) {
        String url = WxEndpoint.get("url.message.send");
        String json = JsonMapper.nonEmptyMapper().toJson((Object)message);
        logger.info("send message: {}", (Object)json);
        this.wxClient.post(url, json);
    }
}

