/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.riversoft.weixin.common.event.EventRequest;
import com.riversoft.weixin.common.exception.WxRuntimeException;
import com.riversoft.weixin.common.message.XmlMessageHeader;
import com.riversoft.weixin.common.util.XmlObjectMapper;
import com.riversoft.weixin.qy.event.BatchJobResultEvent;
import com.riversoft.weixin.qy.event.EnterAgentEvent;
import com.riversoft.weixin.qy.event.QyClickEvent;
import com.riversoft.weixin.qy.event.QyLocationReportEvent;
import com.riversoft.weixin.qy.event.QyLocationSelectEvent;
import com.riversoft.weixin.qy.event.QyPhotoEvent;
import com.riversoft.weixin.qy.event.QyScanEvent;
import com.riversoft.weixin.qy.event.QySubscriptionEvent;
import com.riversoft.weixin.qy.event.QyViewEvent;
import com.riversoft.weixin.qy.request.QyImageRequest;
import com.riversoft.weixin.qy.request.QyLocationRequest;
import com.riversoft.weixin.qy.request.QyShortVideoRequest;
import com.riversoft.weixin.qy.request.QyTextRequest;
import com.riversoft.weixin.qy.request.QyVideoRequest;
import com.riversoft.weixin.qy.request.QyVoiceRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QyXmlMessages {
    private static Logger logger = LoggerFactory.getLogger(QyXmlMessages.class);

    public static XmlMessageHeader fromXml(String xml) {
        try {
            XmlMessageHeader xmlRequest = (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, XmlMessageHeader.class);
            switch (xmlRequest.getMsgType()) {
                case text: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyTextRequest.class);
                }
                case image: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyImageRequest.class);
                }
                case voice: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyVoiceRequest.class);
                }
                case video: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyVideoRequest.class);
                }
                case shortvideo: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyShortVideoRequest.class);
                }
                case location: {
                    return (XmlMessageHeader)XmlObjectMapper.defaultMapper().fromXml(xml, QyLocationRequest.class);
                }
                case event: {
                    return QyXmlMessages.toEvent(xml);
                }
            }
            logger.warn("xml to bean failed, unknown message type {}.", (Object)xmlRequest.getMsgType());
            throw new WxRuntimeException(999, "xml to bean failed, unknown message type " + xmlRequest.getMsgType());
        }
        catch (IOException e) {
            logger.error("xml to message request failed", (Throwable)e);
            throw new WxRuntimeException(999, "xml to message request failed," + e.getMessage());
        }
    }

    private static EventRequest toEvent(String xml) {
        try {
            EventRequest qyEventRequest = (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, EventRequest.class);
            switch (qyEventRequest.getEventType()) {
                case subscribe: 
                case unsubscribe: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QySubscriptionEvent.class);
                }
                case LOCATION: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyLocationReportEvent.class);
                }
                case click: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyClickEvent.class);
                }
                case view: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyViewEvent.class);
                }
                case scancode_push: 
                case scancode_waitmsg: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyScanEvent.class);
                }
                case pic_photo_or_album: 
                case pic_sysphoto: 
                case pic_weixin: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyPhotoEvent.class);
                }
                case location_select: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, QyLocationSelectEvent.class);
                }
                case enter_agent: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, EnterAgentEvent.class);
                }
                case batch_job_result: {
                    return (EventRequest)XmlObjectMapper.defaultMapper().fromXml(xml, BatchJobResultEvent.class);
                }
            }
            logger.warn("xml to event, unknown event type {}.", (Object)qyEventRequest.getEventType());
            throw new WxRuntimeException(999, "xml to bean event, unknown event type " + qyEventRequest.getEventType());
        }
        catch (IOException e) {
            logger.error("xml to event failed", (Throwable)e);
            throw new WxRuntimeException(999, "xml to event failed," + e.getMessage());
        }
    }

    public static String toXml(XmlMessageHeader xmlMessage) {
        try {
            return XmlObjectMapper.defaultMapper().toXml((Object)xmlMessage);
        }
        catch (JsonProcessingException e) {
            logger.error("message to xml failed", (Throwable)e);
            throw new WxRuntimeException(999, "message to xml failed," + e.getMessage());
        }
    }
}

