/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.qy.shake;

import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.qy.QyWxClientFactory;
import com.riversoft.weixin.qy.base.CorpSetting;
import com.riversoft.weixin.qy.base.WxEndpoint;
import com.riversoft.weixin.qy.shake.bean.Shake;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shakes {
    private static Logger logger = LoggerFactory.getLogger(Shakes.class);
    private WxClient wxClient;

    public static Shakes defaultShakes() {
        return Shakes.with(CorpSetting.defaultSettings());
    }

    public static Shakes with(CorpSetting corpSetting) {
        Shakes shakes = new Shakes();
        shakes.setWxClient(QyWxClientFactory.getInstance().with(corpSetting));
        return shakes;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Shake get(String ticket) {
        String url = WxEndpoint.get("url.shake.get");
        String body = String.format("{\"ticket\":\"%s\"}", ticket);
        logger.debug("get shake info: {}", (Object)body);
        String content = this.wxClient.post(url, body);
        ShakeWrapper shakeWrapper = (ShakeWrapper)JsonMapper.nonEmptyMapper().fromJson(content, ShakeWrapper.class);
        return shakeWrapper.getData();
    }

    public static class ShakeWrapper
    implements Serializable {
        private Shake data;

        public Shake getData() {
            return this.data;
        }

        public void setData(Shake data) {
            this.data = data;
        }
    }
}

