/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.context;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.context.model.SaStorage;
import cn.dev33.satoken.exception.SaTokenException;

public class SaTokenContextForThreadLocalStorage {
    static ThreadLocal<Box> boxThreadLocal = new InheritableThreadLocal<Box>();

    public static void setBox(SaRequest request, SaResponse response, SaStorage storage) {
        Box bok = new Box(request, response, storage);
        boxThreadLocal.set(bok);
    }

    public static void clearBox() {
        boxThreadLocal.remove();
    }

    public static Box getBox() {
        return boxThreadLocal.get();
    }

    public static Box getBoxNotNull() {
        Box box = boxThreadLocal.get();
        if (box == null) {
            throw new SaTokenException("\u672a\u6210\u529f\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
        }
        return box;
    }

    public static SaRequest getRequest() {
        return SaTokenContextForThreadLocalStorage.getBoxNotNull().getRequest();
    }

    public static SaResponse getResponse() {
        return SaTokenContextForThreadLocalStorage.getBoxNotNull().getResponse();
    }

    public static SaStorage getStorage() {
        return SaTokenContextForThreadLocalStorage.getBoxNotNull().getStorage();
    }

    public static class Box {
        public SaRequest request;
        public SaResponse response;
        public SaStorage storage;

        public Box(SaRequest request, SaResponse response, SaStorage storage) {
            this.request = request;
            this.response = response;
            this.storage = storage;
        }

        public SaRequest getRequest() {
            return this.request;
        }

        public void setRequest(SaRequest request) {
            this.request = request;
        }

        public SaResponse getResponse() {
            return this.response;
        }

        public void setResponse(SaResponse response) {
            this.response = response;
        }

        public SaStorage getStorage() {
            return this.storage;
        }

        public void setStorage(SaStorage storage) {
            this.storage = storage;
        }

        public String toString() {
            return "Box [request=" + this.request + ", response=" + this.response + ", storage=" + this.storage + "]";
        }
    }
}

