/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.jwt.SaJwtUtil;
import cn.dev33.satoken.jwt.exception.SaJwtException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.List;
import java.util.Map;

public class StpLogicJwtForMixin
extends StpLogic {
    public StpLogicJwtForMixin() {
        super("login");
    }

    public StpLogicJwtForMixin(String loginType) {
        super(loginType);
    }

    public String jwtSecretKey() {
        String keyt = this.getConfigOrGlobal().getJwtSecretKey();
        SaJwtException.throwByNull(keyt, "\u8bf7\u914d\u7f6ejwt\u79d8\u94a5", 30205);
        return keyt;
    }

    public String createTokenValue(Object loginId, String device, long timeout, Map<String, Object> extraData) {
        return SaJwtUtil.createToken(this.loginType, loginId, device, timeout, extraData, this.jwtSecretKey());
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = -2L;
        info.tokenSessionTimeout = -2L;
        info.tokenActiveTimeout = -2L;
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public String getLoginIdNotHandle(String tokenValue) {
        try {
            Object loginId = SaJwtUtil.getLoginId(tokenValue, this.loginType, this.jwtSecretKey());
            return String.valueOf(loginId);
        }
        catch (SaJwtException e) {
            if (e.getCode() == 30204) {
                return "-3";
            }
            return null;
        }
    }

    public void logout() {
        SaHolder.getStorage().delete(this.splicingKeyJustCreatedSave());
        if (this.getConfigOrGlobal().getIsReadCookie().booleanValue()) {
            SaHolder.getResponse().deleteCookie(this.getTokenName());
        }
    }

    public void logout(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public void logoutByTokenValue(String tokenValue) {
        throw new ApiDisabledException();
    }

    public void kickout(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public void kickoutByTokenValue(String tokenValue) {
        throw new ApiDisabledException();
    }

    public void replaced(Object loginId, String device) {
        throw new ApiDisabledException();
    }

    public Object getExtra(String key) {
        return this.getExtra(this.getTokenValue(), key);
    }

    public Object getExtra(String tokenValue, String key) {
        return SaJwtUtil.getPayloads(tokenValue, this.loginType, this.jwtSecretKey()).get((Object)key);
    }

    public void deleteTokenToIdMapping(String tokenValue) {
    }

    public void updateTokenToIdMapping(String tokenValue, Object loginId) {
    }

    public void saveTokenToIdMapping(String tokenValue, Object loginId, long timeout) {
    }

    public long getTokenTimeout(String tokenValue) {
        return SaJwtUtil.getTimeout(tokenValue, this.loginType, this.jwtSecretKey());
    }

    public SaSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        if (SaFoxUtil.isEmpty((Object)tokenValue)) {
            throw new SaTokenException("Token-Session \u83b7\u53d6\u5931\u8d25\uff1atoken \u4e0d\u80fd\u4e3a\u7a7a");
        }
        long timeout = this.getTokenTimeout(tokenValue);
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate, timeout, session -> {
            session.setType("Token-Session");
            session.setLoginType(this.getLoginType());
            session.setToken(tokenValue);
        });
    }

    public List<String> searchTokenValue(String keyword, int start, int size, boolean sortType) {
        throw new ApiDisabledException();
    }

    public boolean getConfigOfIsShare() {
        return false;
    }

    public int getConfigOfMaxTryTimes() {
        return -1;
    }

    public boolean isSupportExtra() {
        return true;
    }
}

