/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.request.bucket;

import cn.herodotus.engine.assistant.core.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.oss.dialect.minio.domain.policy.PolicyDomain;
import cn.herodotus.oss.dialect.minio.domain.policy.StatementDomain;
import cn.herodotus.oss.dialect.minio.enums.PolicyEnums;
import cn.herodotus.oss.rest.minio.definition.BucketRequest;
import com.google.common.collect.Lists;
import io.minio.SetBucketPolicyArgs;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(name="\u8bbe\u7f6e\u5b58\u50a8\u6876\u8bbf\u95ee\u7b56\u7565\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53", title="\u8bbe\u7f6e\u5b58\u50a8\u6876\u8bbf\u95ee\u7b56\u7565\u8bf7\u6c42\u53c2\u6570\u5b9e\u4f53")
public class SetBucketPolicyRequest
extends BucketRequest<SetBucketPolicyArgs.Builder, SetBucketPolicyArgs> {
    private static final String DEFAULT_RESOURCE_PREFIX = "arn:aws:s3:::";
    private static final List<String> DEFAULT_ACTION_FOR_BUCKET = Lists.newArrayList((Object[])new String[]{"s3:GetBucketLocation", "s3:ListBucket", "s3:ListBucketMultipartUploads"});
    private static final List<String> DEFAULT_ACTION_FOR_OBJECT = Lists.newArrayList((Object[])new String[]{"s3:DeleteObject", "s3:GetObject", "s3:ListMultipartUploadParts", "s3:PutObject", "s3:AbortMultipartUpload"});
    @Schema(name="\u8bbf\u95ee\u7b56\u7565\u7c7b\u578b", requiredMode=Schema.RequiredMode.REQUIRED)
    private PolicyEnums type;
    @Schema(name="\u8bbf\u95ee\u7b56\u7565\u914d\u7f6e", description="\u5982\u679c\u4e3a\u81ea\u5b9a\u4e49\u7c7b\u578b\u90a3\u4e48\u5fc5\u9700\u8f93\u5165\u914d\u7f6e\u4fe1\u606f")
    private PolicyDomain config;

    public PolicyEnums getType() {
        return this.type;
    }

    public void setType(PolicyEnums type) {
        this.type = type;
    }

    public PolicyDomain getConfig() {
        return this.config;
    }

    public void setConfig(PolicyDomain config) {
        this.config = config;
    }

    @Override
    public void prepare(SetBucketPolicyArgs.Builder builder) {
        builder.config(Jackson2Utils.toJson((Object)(switch (this.getType()) {
            case PolicyEnums.PUBLIC -> this.getPublicPolicy();
            case PolicyEnums.CUSTOM -> this.getConfig();
            default -> this.getPrivatePolicy(this.getBucketName());
        })));
        super.prepare(builder);
    }

    @Override
    public SetBucketPolicyArgs.Builder getBuilder() {
        return SetBucketPolicyArgs.builder();
    }

    private PolicyDomain getPublicPolicy() {
        return new PolicyDomain();
    }

    private PolicyDomain getPrivatePolicy(String bucketName) {
        StatementDomain bucketStatement = new StatementDomain();
        bucketStatement.setActions(DEFAULT_ACTION_FOR_BUCKET);
        bucketStatement.setResources(this.getDefaultResource(bucketName, true));
        StatementDomain objectStatement = new StatementDomain();
        objectStatement.setActions(DEFAULT_ACTION_FOR_OBJECT);
        objectStatement.setResources(this.getDefaultResource(bucketName, false));
        PolicyDomain policy = new PolicyDomain();
        policy.setStatements((List)Lists.newArrayList((Object[])new StatementDomain[]{bucketStatement, objectStatement}));
        return policy;
    }

    private List<String> getDefaultResource(String bucketName, boolean isForBucket) {
        String suffix = isForBucket ? "" : "/*";
        return Lists.newArrayList((Object[])new String[]{DEFAULT_RESOURCE_PREFIX + bucketName + suffix});
    }
}

