/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.rest.minio.service;

import cn.herodotus.oss.dialect.minio.converter.retention.ObjectLockConfigurationToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.retention.VersioningConfigurationToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.sse.SseConfigurationToEnumConverter;
import cn.herodotus.oss.dialect.minio.domain.ObjectLockConfigurationDomain;
import cn.herodotus.oss.dialect.minio.domain.VersioningConfigurationDomain;
import cn.herodotus.oss.dialect.minio.enums.PolicyEnums;
import cn.herodotus.oss.dialect.minio.enums.SseConfigurationEnums;
import cn.herodotus.oss.dialect.minio.service.MinioBucketEncryptionService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketPolicyService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketQuotaService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketTagsService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketVersioningService;
import cn.herodotus.oss.dialect.minio.service.MinioObjectLockConfigurationService;
import cn.herodotus.oss.rest.minio.bo.BucketSettingBusiness;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketSettingService {
    private final Converter<SseConfiguration, SseConfigurationEnums> toSseConfigurationEnums;
    private final Converter<ObjectLockConfiguration, ObjectLockConfigurationDomain> toObjectLockDomain;
    private final Converter<VersioningConfiguration, VersioningConfigurationDomain> toVersioningDomain;
    private final MinioBucketEncryptionService minioBucketEncryptionService;
    private final MinioBucketPolicyService minioBucketPolicyService;
    private final MinioBucketTagsService minioBucketTagsService;
    private final MinioBucketVersioningService minioBucketVersioningService;
    private final MinioBucketQuotaService minioBucketQuotaService;
    private final MinioObjectLockConfigurationService minioObjectLockConfigurationService;

    public MinioBucketSettingService(MinioBucketEncryptionService minioBucketEncryptionService, MinioBucketPolicyService minioBucketPolicyService, MinioBucketTagsService minioBucketTagsService, MinioBucketVersioningService minioBucketVersioningService, MinioBucketQuotaService minioBucketQuotaService, MinioObjectLockConfigurationService minioObjectLockConfigurationService) {
        this.minioBucketEncryptionService = minioBucketEncryptionService;
        this.minioBucketPolicyService = minioBucketPolicyService;
        this.minioBucketTagsService = minioBucketTagsService;
        this.minioBucketVersioningService = minioBucketVersioningService;
        this.minioBucketQuotaService = minioBucketQuotaService;
        this.minioObjectLockConfigurationService = minioObjectLockConfigurationService;
        this.toSseConfigurationEnums = new SseConfigurationToEnumConverter();
        this.toObjectLockDomain = new ObjectLockConfigurationToDomainConverter();
        this.toVersioningDomain = new VersioningConfigurationToDomainConverter();
    }

    public BucketSettingBusiness get(String bucketName) {
        return this.get(bucketName, null);
    }

    public BucketSettingBusiness get(String bucketName, String region) {
        SseConfiguration sseConfiguration = this.minioBucketEncryptionService.getBucketEncryption(bucketName, region);
        Tags tags = this.minioBucketTagsService.getBucketTags(bucketName, region);
        PolicyEnums policy = this.minioBucketPolicyService.getBucketPolicy(bucketName, region);
        ObjectLockConfiguration objectLockConfiguration = this.minioObjectLockConfigurationService.getObjectLockConfiguration(bucketName, region);
        VersioningConfiguration versioningConfiguration = this.minioBucketVersioningService.getBucketVersioning(bucketName, region);
        long quota = this.minioBucketQuotaService.getBucketQuota(bucketName);
        BucketSettingBusiness entity = new BucketSettingBusiness();
        entity.setSseConfiguration((SseConfigurationEnums)this.toSseConfigurationEnums.convert((Object)sseConfiguration));
        entity.setTags(tags.get());
        entity.setPolicy(policy);
        entity.setQuota(quota);
        entity.setObjectLock((ObjectLockConfigurationDomain)this.toObjectLockDomain.convert((Object)objectLockConfiguration));
        entity.setVersioning((VersioningConfigurationDomain)this.toVersioningDomain.convert((Object)versioningConfiguration));
        return entity;
    }
}

