/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.actuate.endpoint;

import cn.hiboot.mcn.core.model.result.RestResp;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

@Endpoint(id="mcn")
public class McnEndpoint {
    private final ConfigurableEnvironment environment;

    public McnEndpoint(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @ReadOperation
    public RestResp<String> version() {
        return new RestResp((Object)this.environment.getProperty("mcn.version", "UN_KNOW"));
    }

    @ReadOperation
    public RestResp<String> get(@Selector String name) {
        return new RestResp((Object)this.environment.getProperty(name));
    }

    @WriteOperation
    public RestResp<?> add(String name, Object value) {
        MapPropertySource mapPropertySource = (MapPropertySource)this.environment.getPropertySources().get("mcn-map");
        ((Map)mapPropertySource.getSource()).put(name, value);
        return new RestResp();
    }

    @DeleteOperation
    public RestResp<?> delete(@Selector String name) {
        MapPropertySource mapPropertySource = (MapPropertySource)this.environment.getPropertySources().get("mcn-map");
        return new RestResp(((Map)mapPropertySource.getSource()).remove(name));
    }
}

