/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.condition;

import cn.hiboot.mcn.autoconfigure.condition.ConditionalOnPropertyValueNumber;
import cn.hiboot.mcn.core.util.McnUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class OnPropertyValueNumber
extends SpringBootCondition {
    OnPropertyValueNumber() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<AnnotationAttributes> allAnnotationAttributes = this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)metadata.getAllAnnotationAttributes(ConditionalOnPropertyValueNumber.class.getName()));
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        for (AnnotationAttributes annotationAttributes : allAnnotationAttributes) {
            ConditionOutcome outcome = this.determineOutcome(annotationAttributes, (PropertyResolver)context.getEnvironment());
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.of(match));
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        multiValueMap.forEach((key, value) -> {
            for (int i = 0; i < value.size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put((String)key, value.get(i));
            }
        });
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }

    private ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        return new Spec(annotationAttributes).check(resolver);
    }

    private static class Spec {
        private final String prefix;
        private final String name;
        private final int min;
        private final int max;

        Spec(AnnotationAttributes annotationAttributes) {
            String prefix = annotationAttributes.getString("prefix").trim();
            if (StringUtils.hasText((String)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            this.prefix = prefix;
            this.min = (Integer)annotationAttributes.getNumber("min");
            this.max = (Integer)annotationAttributes.getNumber("max");
            this.name = annotationAttributes.getString("name").trim();
            Assert.state((boolean)McnUtils.isNotNullAndEmpty((Object)this.name), (String)"The name or value attribute of @ConditionalOnPropertyValueNumber must be specified");
        }

        private ConditionOutcome check(PropertyResolver resolver) {
            String key = this.prefix + this.name;
            String[] dbs = (String[])resolver.getProperty(key, String[].class);
            if (dbs != null && dbs.length >= this.min && dbs.length <= this.max) {
                return ConditionOutcome.match((String)("match " + dbs.length + " value"));
            }
            return ConditionOutcome.noMatch((String)("no value number >= " + this.min + " and number <= " + this.max));
        }

        public String toString() {
            return "(" + this.prefix + this.name + ",min = " + this.min + ",max = " + this.max + ")";
        }
    }
}

