/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ComponentScanPackageCheck {
    private final Logger log = LoggerFactory.getLogger(ComponentScanPackageCheck.class);
    private static final Set<String> PROBLEM_PACKAGES = new HashSet<String>();

    public ComponentScanPackageCheck() {
        PROBLEM_PACKAGES.add("cn");
        PROBLEM_PACKAGES.add("cn.hiboot");
    }

    public void check(BeanDefinitionRegistry registry) {
        String message = this.getWarning(registry);
        if (StringUtils.hasLength((String)message)) {
            this.log.warn(String.format("%n%n** WARNING ** : %s%n%n", message));
        }
    }

    private String getWarning(BeanDefinitionRegistry registry) {
        Set<String> scannedPackages = this.getComponentScanningPackages(registry);
        List<String> problematicPackages = this.getProblematicPackages(scannedPackages);
        if (problematicPackages.isEmpty()) {
            return null;
        }
        return "Your ApplicationContext is unlikely to start due to a @ComponentScan of " + StringUtils.collectionToDelimitedString(problematicPackages, (String)", ") + ".";
    }

    private Set<String> getComponentScanningPackages(BeanDefinitionRegistry registry) {
        String[] names;
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        for (String name : names = registry.getBeanDefinitionNames()) {
            BeanDefinition definition = registry.getBeanDefinition(name);
            if (!(definition instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition annotatedDefinition = (AnnotatedBeanDefinition)definition;
            this.addComponentScanningPackages(packages, annotatedDefinition.getMetadata());
        }
        return packages;
    }

    private void addComponentScanningPackages(Set<String> packages, AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
        if (attributes != null) {
            this.addPackages(packages, attributes.getStringArray("value"));
            this.addPackages(packages, attributes.getStringArray("basePackages"));
            this.addClasses(packages, attributes.getStringArray("basePackageClasses"));
            if (packages.isEmpty()) {
                packages.add(ClassUtils.getPackageName((String)metadata.getClassName()));
            }
        }
    }

    private void addPackages(Set<String> packages, String[] values) {
        if (values != null) {
            Collections.addAll(packages, values);
        }
    }

    private void addClasses(Set<String> packages, String[] values) {
        if (values != null) {
            for (String value : values) {
                packages.add(ClassUtils.getPackageName((String)value));
            }
        }
    }

    private List<String> getProblematicPackages(Set<String> scannedPackages) {
        ArrayList<String> problematicPackages = new ArrayList<String>();
        for (String scannedPackage : scannedPackages) {
            if (!this.isProblematicPackage(scannedPackage)) continue;
            problematicPackages.add(this.getDisplayName(scannedPackage));
        }
        return problematicPackages;
    }

    private boolean isProblematicPackage(String scannedPackage) {
        if (scannedPackage == null || scannedPackage.isEmpty()) {
            return true;
        }
        return PROBLEM_PACKAGES.contains(scannedPackage);
    }

    private String getDisplayName(String scannedPackage) {
        if (scannedPackage == null || scannedPackage.isEmpty()) {
            return "the default package";
        }
        return "'" + scannedPackage + "'";
    }
}

