/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.config;

import cn.hiboot.mcn.autoconfigure.web.exception.error.ErrorPageController;
import cn.hiboot.mcn.core.util.McnUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.util.HtmlUtils;

public abstract class ConfigProperties {
    private static final String DATA_SOURCE = "DataSource";
    public static final String APP_BASE_PACKAGE = "app.base-package";
    public static final String MULTIPLE_DATASOURCE_PREFIX = "multiple.datasource";
    public static final String JPA_MULTIPLE_DATASOURCE_PREFIX = "jpa.multiple.datasource";
    public static final String MYBATIS_MULTIPLE_DATASOURCE_PREFIX = "mybatis.multiple.datasource";
    public static final String DYNAMIC_DATASOURCE_PREFIX = "dynamic.datasource";
    public static final String DAO_PACKAGE_NAME = "dao.package.name";
    public static final String BASE_PACKAGE_NAME = "base.package.name";
    private static String error_view;

    public static Map<String, Object> loadConfig(ClassLoader classLoader, String location) {
        if (classLoader == null) {
            classLoader = ConfigProperties.class.getClassLoader();
        }
        Properties properties = new Properties();
        try {
            properties = PropertiesLoaderUtils.loadAllProperties((String)location, (ClassLoader)classLoader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static ClassPathResource mcnDefault() {
        return ConfigProperties.createResource("mcn-default.properties", ConfigProperties.class);
    }

    public static ClassPathResource createResource(String file, Class<?> clazz) {
        return new ClassPathResource(file, clazz);
    }

    public static String errorView(Map<String, ?> error, String basePath) {
        String status = error.get("status").toString();
        Object message = error.get("message");
        if (McnUtils.isNullOrEmpty(message)) {
            message = error.get("error");
        }
        String msg = message == null ? "" : message.toString();
        return error_view.replace("{status}", ConfigProperties.htmlEscape(status)).replace("{msg}", ConfigProperties.htmlEscape(msg));
    }

    private static String htmlEscape(Object input) {
        return input != null ? HtmlUtils.htmlEscape((String)input.toString()) : null;
    }

    public static String getDataSourceBeanName(String dsName) {
        return dsName + DATA_SOURCE;
    }

    static {
        try {
            error_view = StreamUtils.copyToString((InputStream)ConfigProperties.createResource("defaultErrorView.html", ErrorPageController.class).getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

