/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.context;

import cn.hiboot.mcn.autoconfigure.bootstrap.LogFileChecker;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class McnApplicationListener
implements GenericApplicationListener {
    private final Logger log = LoggerFactory.getLogger(McnApplicationListener.class);
    private static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    private static final String SECURITY_CONTEXT_HOLDER_STRATEGY_SYSTEM_PROPERTY = "spring.security.strategy";
    public static final int DEFAULT_ORDER = -2147483627;
    private static final Class<?>[] EVENT_TYPES = new Class[]{SpringApplicationEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class};

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ApplicationStartingEvent) {
            this.onApplicationStartingEvent((ApplicationStartingEvent)applicationEvent);
        } else if (applicationEvent instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)applicationEvent);
        } else if (applicationEvent instanceof ApplicationContextInitializedEvent) {
            this.onApplicationContextInitializedEvent((ApplicationContextInitializedEvent)applicationEvent);
        } else if (applicationEvent instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent((ApplicationPreparedEvent)applicationEvent);
        } else if (applicationEvent instanceof ApplicationReadyEvent) {
            this.onApplicationReadyEvent((ApplicationReadyEvent)applicationEvent);
        }
    }

    private void onApplicationStartingEvent(ApplicationStartingEvent event) {
        if (!StringUtils.hasText((String)System.getProperty(SECURITY_CONTEXT_HOLDER_STRATEGY_SYSTEM_PROPERTY)) && ClassUtils.isPresent((String)"org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken", null) && ClassUtils.isPresent((String)"feign.Feign", null)) {
            System.setProperty(SECURITY_CONTEXT_HOLDER_STRATEGY_SYSTEM_PROPERTY, "MODE_INHERITABLETHREADLOCAL");
        }
        event.getBootstrapContext().registerIfAbsent(LogFileChecker.class, BootstrapRegistry.InstanceSupplier.of((Object)new LogFileChecker()));
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        ConfigurableBootstrapContext bootstrapContext = event.getBootstrapContext();
        ((LogFileChecker)bootstrapContext.getOrElse(LogFileChecker.class, (Object)new LogFileChecker())).setEnvironment(environment);
    }

    private void onApplicationContextInitializedEvent(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        if (((Boolean)environment.getProperty("mcn.print-env.enable", Boolean.class, (Object)false)).booleanValue()) {
            for (PropertySource propertySource : environment.getPropertySources()) {
                String name = propertySource.getName();
                if (!(propertySource instanceof EnumerablePropertySource)) {
                    System.out.println();
                    this.log.info("skip propertySource name = {} because it's not enumerable", (Object)name);
                    continue;
                }
                String[] propertyNames = ((EnumerablePropertySource)propertySource).getPropertyNames();
                if (propertyNames.length == 0) {
                    System.out.println();
                    this.log.info("ignore propertySource name = {} because no config property", (Object)name);
                    continue;
                }
                System.out.println();
                this.log.info("start print ------------ {} ------------ ", (Object)name);
                for (String propertyName : propertyNames) {
                    this.log.info("{} = {}", (Object)propertyName, propertySource.getProperty(propertyName));
                }
            }
        }
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        SpringBeanUtils.setApplicationContext((ApplicationContext)event.getApplicationContext());
    }

    private void onApplicationReadyEvent(ApplicationReadyEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        if (((Boolean)environment.getProperty("erase.decrypted-data.enable", Boolean.TYPE, (Object)false)).booleanValue()) {
            environment.getPropertySources().remove(DECRYPTED_PROPERTY_SOURCE_NAME);
        }
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        return this.isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    private boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public int getOrder() {
        return -2147483627;
    }
}

