/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.context;

import cn.hiboot.mcn.core.util.JacksonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class McnBeanPostProcessor
implements BeanPostProcessor {
    private final ConfigurableEnvironment environment;

    public McnBeanPostProcessor(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObjectMapper) {
            JacksonUtils.setObjectMapper((ObjectMapper)((ObjectMapper)bean));
        } else {
            this.mappingDbCustomConfigToStandardConfig(bean);
        }
        return bean;
    }

    private void mappingDbCustomConfigToStandardConfig(Object bean) {
        if (bean instanceof MongoProperties) {
            this.mappingMongoConfig((MongoProperties)bean);
        } else if (bean instanceof RedisProperties) {
            this.mappingRedisConfig((RedisProperties)bean);
        }
    }

    private void mappingMongoConfig(MongoProperties mongoProperties) {
        if (mongoProperties.getUri() != null) {
            return;
        }
        String mongoAddress = this.environment.getProperty("mongo.addrs");
        if (StringUtils.hasText((String)mongoAddress)) {
            String username = this.environment.getProperty("mongo.username");
            String password = this.environment.getProperty("mongo.password");
            String uri = mongoAddress;
            if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
                uri = this.replace(username) + ":" + this.replace(password) + "@" + mongoAddress;
            }
            mongoProperties.setUri("mongodb://" + uri);
        }
    }

    private String replace(String str) {
        return str.replace(":", "%3A").replace("@", "%40").replace("/", "%2F");
    }

    private void mappingRedisConfig(RedisProperties redisProperties) {
        String redisAddress = this.environment.getProperty("redis.addrs");
        if (StringUtils.hasText((String)redisAddress)) {
            String master = this.environment.getProperty("redis.sentinel");
            List<String> hosts = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)redisAddress));
            if (StringUtils.hasText((String)master)) {
                RedisProperties.Sentinel sentinel = redisProperties.getSentinel();
                if (sentinel == null) {
                    sentinel = new RedisProperties.Sentinel();
                }
                sentinel.setMaster(master);
                sentinel.setNodes(hosts);
                if (StringUtils.hasText((String)redisProperties.getPassword()) && ObjectUtils.isEmpty((Object)sentinel)) {
                    sentinel.setPassword(redisProperties.getPassword());
                }
                redisProperties.setSentinel(sentinel);
            } else if (hosts.size() == 1) {
                String[] hp = hosts.get(0).split(":");
                redisProperties.setHost(hp[0]);
                redisProperties.setPort(Integer.parseInt(hp[1]));
            } else {
                RedisProperties.Cluster cluster = redisProperties.getCluster();
                if (cluster == null) {
                    cluster = new RedisProperties.Cluster();
                }
                cluster.setNodes(hosts);
                redisProperties.setCluster(cluster);
            }
        }
    }
}

