/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.context;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.core.util.McnUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.util.ClassUtils;

public class McnEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final boolean PRESENT = ClassUtils.isPresent((String)"ch.qos.logback.classic.LoggerContext", (ClassLoader)McnEnvironmentPostProcessor.class.getClassLoader());
    private static final MapPropertySource EMPTY_PROPERTY_SOURCE = new MapPropertySource("Empty", Collections.emptyMap());
    private static final String BOOTSTRAP_EAGER_LOAD = "mcn.bootstrap.eagerLoad.enable";
    private static final String MCN_SOURCE_NAME = "mcn-global-unique";
    private static final String MCN_DEFAULT_PROPERTY_SOURCE_NAME = "mcn-default";
    private static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.loadMcnConfigFile(environment);
        if (environment.getPropertySources().contains(BOOTSTRAP_PROPERTY_SOURCE_NAME) && !((Boolean)environment.getProperty(BOOTSTRAP_EAGER_LOAD, Boolean.class, (Object)false)).booleanValue()) {
            return;
        }
        this.loadDefaultConfig(environment, application.getMainApplicationClass());
    }

    private void loadMcnConfigFile(ConfigurableEnvironment environment) {
        if (environment.getPropertySources().contains(MCN_SOURCE_NAME)) {
            return;
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        String[] activeProfiles = environment.getActiveProfiles();
        if (activeProfiles.length > 0) {
            for (int i = activeProfiles.length - 1; i >= 0; --i) {
                String activeProfile = activeProfiles[i];
                this.addLast(propertySources, this.loadResourcePropertySource(MCN_SOURCE_NAME.concat("-").concat(activeProfile), "classpath:config/mcn-" + activeProfile + ".properties"));
            }
        }
        this.addLast(propertySources, this.loadResourcePropertySource(MCN_SOURCE_NAME, "classpath:config/mcn.properties"));
    }

    private void loadDefaultConfig(ConfigurableEnvironment environment, Class<?> mainApplicationClass) {
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains(MCN_DEFAULT_PROPERTY_SOURCE_NAME)) {
            return;
        }
        HashMap<String, String> mapProp = new HashMap<String, String>();
        if (Objects.nonNull(mainApplicationClass)) {
            String packageName = ClassUtils.getPackageName(mainApplicationClass);
            mapProp.put("app.base-package", packageName);
            mapProp.put("logging.level." + packageName + ".dao", "info");
            String projectVersion = McnUtils.getVersion(mainApplicationClass);
            if (projectVersion != null) {
                mapProp.put("project.version", projectVersion);
            }
        }
        mapProp.put("mcn.log.file.name", environment.getProperty("mcn.log.file.name", "error"));
        mapProp.put("mcn.version", "v" + McnUtils.getVersion(this.getClass()));
        this.addLast(propertySources, new MapPropertySource("mcn-map", mapProp));
        MapPropertySource propertySource = this.loadResourcePropertySource(MCN_DEFAULT_PROPERTY_SOURCE_NAME, ConfigProperties.mcnDefault());
        if (!PRESENT) {
            ((Map)propertySource.getSource()).remove("logging.pattern.console");
            ((Map)propertySource.getSource()).remove("logging.pattern.file");
        }
        String additionConfigFile = environment.getProperty("mcn.config.additional-file", "config/config.properties");
        ((Map)propertySource.getSource()).putAll(ConfigProperties.loadConfig(null, additionConfigFile));
        this.addLast(propertySources, propertySource);
    }

    private MapPropertySource loadResourcePropertySource(String name, Object resource) {
        try {
            if (resource instanceof Resource) {
                return new ResourcePropertySource(name, (Resource)resource);
            }
            return new ResourcePropertySource(name, resource.toString());
        }
        catch (IOException e) {
            return EMPTY_PROPERTY_SOURCE;
        }
    }

    private void addLast(MutablePropertySources propertySources, MapPropertySource propertySource) {
        if (propertySource == EMPTY_PROPERTY_SOURCE) {
            return;
        }
        propertySources.addLast((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147483637;
    }
}

