/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jdbc;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.autoconfigure.jdbc.ConditionalOnMultipleDataSource;
import cn.hiboot.mcn.autoconfigure.jdbc.DataSourceHolder;
import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceConfig;
import cn.hiboot.mcn.autoconfigure.jdbc.SwitchSourceAdvisor;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.datasource.lookup.BeanFactoryDataSourceLookup;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class}, afterName={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
@ConditionalOnMultipleDataSource
@ConditionalOnClass(value={HikariDataSource.class})
@Import(value={MultipleDataSourceRegister.class})
public class MultipleDataSourceAutoConfiguration {

    static class MultipleDataSourceRegister
    implements ImportBeanDefinitionRegistrar {
        private final BeanFactory beanFactory;

        public MultipleDataSourceRegister(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            MultipleDataSourceConfig multipleDataSourceConfig = (MultipleDataSourceConfig)this.beanFactory.getBean(MultipleDataSourceConfig.class);
            Map<String, DataSourceProperties> properties = multipleDataSourceConfig.getProperties();
            properties.forEach((dsName, ds) -> {
                String dataSourceName = ConfigProperties.getDataSourceBeanName(dsName);
                registry.registerBeanDefinition(dataSourceName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(HikariDataSource.class, () -> this.createDataSource((DataSourceProperties)ds)).getBeanDefinition());
            });
            if (multipleDataSourceConfig.enableDynamicDatasource()) {
                registry.registerBeanDefinition("defaultRoutingDataSource", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MultipleDataSourceRegister.class).setFactoryMethod("defaultRoutingDataSource").addConstructorArgValue((Object)multipleDataSourceConfig).addConstructorArgValue((Object)this.beanFactory).setPrimary(true).getBeanDefinition());
                registry.registerBeanDefinition(SwitchSourceAdvisor.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SwitchSourceAdvisor.class).setRole(2).getBeanDefinition());
            }
        }

        static AbstractRoutingDataSource defaultRoutingDataSource(MultipleDataSourceConfig multipleDataSourceConfig, BeanFactory beanFactory) {
            AbstractRoutingDataSource dataSource = new AbstractRoutingDataSource(){

                protected Object determineCurrentLookupKey() {
                    return DataSourceHolder.getDataSource();
                }
            };
            dataSource.setDataSourceLookup((DataSourceLookup)new BeanFactoryDataSourceLookup(beanFactory));
            String defaultDataSource = null;
            HashMap<String, String> dataSourceMap = new HashMap<String, String>();
            for (String s : multipleDataSourceConfig.getProperties().keySet()) {
                String beanName = ConfigProperties.getDataSourceBeanName(s);
                if (defaultDataSource == null) {
                    defaultDataSource = beanName;
                }
                dataSourceMap.put(s, beanName);
            }
            dataSource.setTargetDataSources(dataSourceMap);
            dataSource.setDefaultTargetDataSource(defaultDataSource);
            return dataSource;
        }

        private HikariDataSource createDataSource(DataSourceProperties dataSourceProperties) {
            return (HikariDataSource)dataSourceProperties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        }
    }
}

