/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jdbc;

import cn.hiboot.mcn.core.util.McnUtils;
import java.util.Map;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.env.Environment;

public class MultipleDataSourceConfig {
    private final Map<String, DataSourceProperties> properties;
    private final Environment environment;
    private final int vote;
    private final String daoPackageName;
    private String basePackage;

    public MultipleDataSourceConfig(Map<String, DataSourceProperties> properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
        this.vote = this.checkConfig(environment);
        this.daoPackageName = environment.getProperty("dao.package.name", "dao");
        this.basePackage = environment.getProperty("base.package.name");
        if (McnUtils.isNullOrEmpty((Object)this.basePackage)) {
            this.basePackage = environment.getProperty("app.base-package");
        }
    }

    private int checkConfig(Environment environment) {
        int vote = 0;
        if (((Boolean)environment.getProperty("jpa.multiple.datasource.enable", Boolean.class, (Object)false)).booleanValue()) {
            ++vote;
        }
        if (((Boolean)environment.getProperty("mybatis.multiple.datasource.enable", Boolean.class, (Object)false)).booleanValue()) {
            ++vote;
        }
        if (((Boolean)environment.getProperty("dynamic.datasource.enable", Boolean.class, (Object)false)).booleanValue()) {
            ++vote;
        }
        if (vote > 1) {
            throw new IllegalArgumentException("mybatis and jpa multiple datasource and dynamic datasource only config one!");
        }
        return vote;
    }

    public Map<String, DataSourceProperties> getProperties() {
        return this.properties;
    }

    public String getDaoPackageName() {
        return this.daoPackageName;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    boolean enableDynamicDatasource() {
        Boolean enable = (Boolean)this.environment.getProperty("dynamic.datasource.enable", Boolean.class);
        if (this.vote == 0) {
            return enable == null || enable != false;
        }
        return Boolean.TRUE.equals(enable);
    }
}

