/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jdbc;

import cn.hiboot.mcn.autoconfigure.jdbc.DataSourceHolder;
import cn.hiboot.mcn.autoconfigure.jdbc.SwitchSource;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;

class SwitchSourceAdvisor
extends AbstractPointcutAdvisor {
    private static final Map<Method, String> cache = new ConcurrentHashMap<Method, String>();
    private final Pointcut pointcut;

    public SwitchSourceAdvisor() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(SwitchSource.class, true);
        ComposablePointcut result = new ComposablePointcut((Pointcut)cpc);
        AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, SwitchSource.class, true);
        this.pointcut = result.union((Pointcut)mpc);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return invocation -> {
            String ds = cache.computeIfAbsent(invocation.getMethod(), m -> {
                SwitchSource annotation = invocation.getMethod().getAnnotation(SwitchSource.class);
                if (annotation == null) {
                    annotation = invocation.getMethod().getDeclaringClass().getAnnotation(SwitchSource.class);
                }
                return annotation.value();
            });
            DataSourceHolder.setDataSource(ds);
            Object o = invocation.proceed();
            DataSourceHolder.clearDataSource();
            return o;
        };
    }
}

