/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa;

import cn.hiboot.mcn.autoconfigure.jpa.BaseRepository;
import cn.hiboot.mcn.autoconfigure.jpa.JpaUtils;
import cn.hiboot.mcn.core.model.base.FieldSort;
import cn.hiboot.mcn.core.model.base.PageSort;
import cn.hiboot.mcn.core.model.result.RestResp;
import java.util.List;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public interface BaseService<T, PK, R extends BaseRepository<T, PK>> {
    public R getRepository();

    default public T save(T data) {
        this.beforeSave(data);
        return (T)this.getRepository().save(data);
    }

    default public List<T> saveAll(List<T> data) {
        return this.getRepository().saveAll(data);
    }

    default public void beforeSave(T data) {
    }

    default public void deleteById(PK id) {
        this.getRepository().findById(id).ifPresent(u -> this.getRepository().delete(u));
    }

    default public T getById(PK id) {
        return this.getRepository().findById(id).orElse(null);
    }

    default public T getOne(T t) {
        return this.getRepository().findOne(Example.of(t)).orElse(null);
    }

    default public List<T> list(T t) {
        return this.getRepository().findAll(Example.of(t));
    }

    default public List<T> list(T t, List<FieldSort> sort) {
        return this.getRepository().findAll(Example.of(t), JpaUtils.jpaSort(sort));
    }

    default public RestResp<List<T>> page(T t, PageSort pageSort) {
        PageRequest pageRequest = PageRequest.of((int)pageSort.getPageIndex(), (int)pageSort.getPageSize(), (Sort)JpaUtils.jpaSort(pageSort.getSort()));
        Page page = t == null ? this.getRepository().findAll((Pageable)pageRequest) : this.getRepository().findAll(Example.of(t), (Pageable)pageRequest);
        return new RestResp((Object)page.getContent(), page.getTotalElements());
    }

    default public T getOne(Specification<T> s) {
        return this.getRepository().findOne(s).orElse(null);
    }

    default public List<T> list(Specification<T> s) {
        return this.getRepository().findAll(s);
    }

    default public List<T> list(Specification<T> s, List<FieldSort> sort) {
        return this.getRepository().findAll(s, JpaUtils.jpaSort(sort));
    }

    default public RestResp<List<T>> page(Specification<T> s, PageSort pageSort) {
        PageRequest pageRequest = PageRequest.of((int)pageSort.getPageIndex(), (int)pageSort.getPageSize(), (Sort)JpaUtils.jpaSort(pageSort.getSort()));
        Page page = this.getRepository().findAll(s, (Pageable)pageRequest);
        return new RestResp((Object)page.getContent(), page.getTotalElements());
    }

    default public void updateById(PK id, T data) {
        this.getRepository().findById(id).ifPresent(d -> {
            this.beforeUpdate(d, data);
            JpaUtils.copyTo(data, d);
            this.getRepository().save(d);
        });
    }

    default public void beforeUpdate(T oldData, T newData) {
    }
}

