/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa;

import cn.hiboot.mcn.autoconfigure.jpa.PredicateProvider;
import cn.hiboot.mcn.core.util.McnUtils;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Example;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.lang.NonNull;

public class ExampleSpecification<T>
implements Specification<T> {
    private final PredicateProvider<T>[] predicateProviders;
    private Example<T> example;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private boolean isOr;

    @SafeVarargs
    ExampleSpecification(PredicateProvider<T> ... predicateProviders) {
        this.predicateProviders = predicateProviders;
    }

    @SafeVarargs
    ExampleSpecification(T bean, PredicateProvider<T> ... predicateProviders) {
        this(predicateProviders);
        if (!McnUtils.isFieldAllNull(bean)) {
            this.example = Example.of(bean);
        }
    }

    ExampleSpecification<T> or() {
        this.isOr = true;
        return this;
    }

    public ExampleSpecification<T> escapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
        return this;
    }

    public Predicate toPredicate(@NonNull Root<T> root, @NonNull CriteriaQuery<?> query, @NonNull CriteriaBuilder criteriaBuilder) {
        if (this.example == null && McnUtils.isNullOrEmpty(this.predicateProviders)) {
            return null;
        }
        Predicate beanPredicate = null;
        if (this.example != null) {
            beanPredicate = criteriaBuilder.and(new Predicate[]{QueryByExamplePredicateBuilder.getPredicate(root, (CriteriaBuilder)criteriaBuilder, this.example, (EscapeCharacter)this.escapeCharacter)});
        }
        Predicate[] predicates = this.predicates(this.predicateProviders, root, criteriaBuilder);
        Predicate logicPredicate = null;
        if (McnUtils.isNotNullAndEmpty((Object)predicates)) {
            Predicate predicate = logicPredicate = this.isOr ? criteriaBuilder.or(predicates) : criteriaBuilder.and(predicates);
        }
        if (beanPredicate == null && logicPredicate == null) {
            return null;
        }
        if (beanPredicate == null) {
            return logicPredicate;
        }
        if (logicPredicate == null) {
            return beanPredicate;
        }
        return this.isOr ? criteriaBuilder.or((Expression)beanPredicate, (Expression)logicPredicate) : criteriaBuilder.and((Expression)beanPredicate, (Expression)logicPredicate);
    }

    private Predicate[] predicates(PredicateProvider<T>[] predicateProviders, Root<T> root, CriteriaBuilder criteriaBuilder) {
        if (McnUtils.isNullOrEmpty(predicateProviders)) {
            return null;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(predicateProviders.length);
        for (PredicateProvider<T> predicateProvider : predicateProviders) {
            Predicate predicate = predicateProvider.getPredicate(root, criteriaBuilder);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        return predicates.toArray(new Predicate[0]);
    }
}

