/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceAutoConfiguration;
import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceConfig;
import cn.hiboot.mcn.autoconfigure.jpa.JpaConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionRegistrarSupport;
import org.springframework.data.repository.config.RepositoryConfigurationDelegate;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationUtils;
import org.springframework.util.ReflectionUtils;

@AutoConfiguration(after={MultipleDataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class})
@ConditionalOnProperty(prefix="jpa.multiple.datasource", name={"enable"}, havingValue="true")
@ConditionalOnClass(value={JpaRepository.class})
@ConditionalOnBean(value={MultipleDataSourceConfig.class})
@Import(value={JpaRepositoriesRegistrar.class})
public class JpaMultipleDataSourceAutoConfiguration {

    static class JpaRepositoriesRegistrar
    extends RepositoryBeanDefinitionRegistrarSupport {
        private final Environment environment;
        private final ResourceLoader resourceLoader;
        private final MultipleDataSourceConfig multipleDataSourceConfig;

        public JpaRepositoriesRegistrar(Environment environment, ResourceLoader resourceLoader, BeanFactory beanFactory) {
            this.environment = environment;
            this.resourceLoader = resourceLoader;
            this.multipleDataSourceConfig = (MultipleDataSourceConfig)beanFactory.getBean(MultipleDataSourceConfig.class);
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator generator) {
            String basePackage = this.multipleDataSourceConfig.getBasePackage();
            AnnotationMetadata metadata = AnnotationMetadata.introspect(EnableJpaRepositoriesConfiguration.class);
            AnnotationRepositoryConfigurationSource configurationSource = new AnnotationRepositoryConfigurationSource(metadata, this.getAnnotation(), this.resourceLoader, this.environment, registry, generator);
            AnnotationAttributes annotationAttributes = this.getAnnotationAttributes(configurationSource);
            if (annotationAttributes == null) {
                return;
            }
            JpaProperties jpaProperties = (JpaProperties)Binder.get((Environment)this.environment).bind("spring.jpa", JpaProperties.class).orElse((Object)new JpaProperties());
            RepositoryConfigurationExtension extension = this.getExtension();
            RepositoryConfigurationUtils.exposeRegistration((RepositoryConfigurationExtension)extension, (BeanDefinitionRegistry)registry, (RepositoryConfigurationSource)configurationSource);
            RepositoryConfigurationDelegate delegate = new RepositoryConfigurationDelegate((RepositoryConfigurationSource)configurationSource, this.resourceLoader, this.environment);
            this.multipleDataSourceConfig.getProperties().forEach((dsName, ds) -> {
                String entityManagerFactoryRef = dsName + "EntityManagerFactory";
                String transactionManagerRef = dsName + "TransactionManager";
                annotationAttributes.put((Object)"basePackages", (Object)(basePackage + "." + this.multipleDataSourceConfig.getDaoPackageName() + "." + dsName));
                annotationAttributes.put((Object)"entityManagerFactoryRef", (Object)entityManagerFactoryRef);
                annotationAttributes.put((Object)"transactionManagerRef", (Object)transactionManagerRef);
                String configBeanName = dsName + "JpaConfiguration";
                registry.registerBeanDefinition(configBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(JpaConfiguration.class).addPropertyReference("dataSource", ConfigProperties.getDataSourceBeanName(dsName)).addPropertyValue("packages", (Object)(basePackage + ".bean")).addPropertyValue("persistenceUnit", dsName).addPropertyValue("jpaProperties", (Object)jpaProperties).setRole(2).getBeanDefinition());
                registry.registerBeanDefinition(entityManagerFactoryRef, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethodOnBean("localContainerEntityManagerFactoryBean", configBeanName).addConstructorArgReference("entityManagerFactoryBuilder").getBeanDefinition());
                registry.registerBeanDefinition(transactionManagerRef, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition().setFactoryMethodOnBean("transactionManager", configBeanName).addConstructorArgReference("&" + entityManagerFactoryRef).getBeanDefinition());
                delegate.registerRepositoriesIn(registry, extension);
            });
        }

        private AnnotationAttributes getAnnotationAttributes(AnnotationRepositoryConfigurationSource configurationSource) {
            Field attributes = ReflectionUtils.findField(AnnotationRepositoryConfigurationSource.class, (String)"attributes");
            ReflectionUtils.makeAccessible((Field)attributes);
            try {
                return (AnnotationAttributes)attributes.get(configurationSource);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        protected Class<? extends Annotation> getAnnotation() {
            return EnableJpaRepositories.class;
        }

        protected RepositoryConfigurationExtension getExtension() {
            return new JpaRepositoryConfigExtension();
        }

        @EnableJpaRepositories
        private static class EnableJpaRepositoriesConfiguration {
            private EnableJpaRepositoriesConfiguration() {
            }
        }
    }
}

