/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa;

import cn.hiboot.mcn.core.model.base.FieldSort;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.domain.Sort;

public abstract class JpaUtils {
    public static Sort jpaSort(List<FieldSort> sort) {
        Sort jpaSort = null;
        for (FieldSort fieldSort : sort) {
            Sort s = JpaUtils.jpaSort(fieldSort);
            if (jpaSort == null) {
                jpaSort = s;
                continue;
            }
            jpaSort = jpaSort.and(s);
        }
        return jpaSort == null ? Sort.unsorted() : jpaSort;
    }

    public static Sort jpaSort(FieldSort fieldSort) {
        if (fieldSort.getSort() == null) {
            return Sort.unsorted();
        }
        if ("asc".equalsIgnoreCase(fieldSort.getSort())) {
            return Sort.by((String[])new String[]{fieldSort.getField()}).ascending();
        }
        return Sort.by((String[])new String[]{fieldSort.getField()}).descending();
    }

    public static void copyTo(Object updateData, Object existData) {
        BeanUtils.copyProperties((Object)updateData, (Object)existData, (String[])JpaUtils.getNullPropertyNames(updateData));
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        return (String[])Arrays.stream(src.getPropertyDescriptors()).map(FeatureDescriptor::getName).filter(arg_0 -> JpaUtils.lambda$getNullPropertyNames$0((BeanWrapper)src, arg_0)).toArray(String[]::new);
    }

    private static /* synthetic */ boolean lambda$getNullPropertyNames$0(BeanWrapper src, String name) {
        return src.getPropertyValue(name) == null;
    }
}

