/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa.predicate;

import cn.hiboot.mcn.autoconfigure.jpa.AbstractPredicateProvider;
import java.util.Date;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class DateBetweenPredicate<T>
extends AbstractPredicateProvider<T> {
    private final Date startTime;
    private final Date endTime;

    public DateBetweenPredicate(String fieldName, Date startTime, Date endTime) {
        super(fieldName);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public boolean isValid() {
        return Objects.nonNull(this.startTime) && Objects.nonNull(this.endTime);
    }

    @Override
    protected Predicate doGetPredicate(Root<T> root, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.between((Expression)root.get(this.getFieldName()), (Comparable)this.startTime, (Comparable)this.endTime);
    }
}

