/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.jpa.predicate;

import cn.hiboot.mcn.autoconfigure.jpa.AbstractPredicateProvider;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.util.StringUtils;

public class FieldLikePredicate<T>
extends AbstractPredicateProvider<T> {
    private static final String LIKE = "%";
    private final String value;
    private boolean isNot;
    private boolean prefix;
    private boolean suffix;

    public FieldLikePredicate(String fieldName, String value) {
        super(fieldName);
        this.value = value;
    }

    @Override
    public boolean isValid() {
        return StringUtils.hasText((String)this.value);
    }

    @Override
    public Predicate doGetPredicate(Root<T> root, CriteriaBuilder criteriaBuilder) {
        String pattern = this.prefix ? LIKE + this.value : (this.suffix ? this.value + LIKE : LIKE + this.value + LIKE);
        Expression as = root.get(this.getFieldName()).as(String.class);
        return this.isNot ? criteriaBuilder.notLike(as, pattern) : criteriaBuilder.like(as, pattern);
    }

    public FieldLikePredicate<T> not() {
        this.isNot = true;
        return this;
    }

    private FieldLikePredicate<T> prefix() {
        this.prefix = true;
        return this;
    }

    private FieldLikePredicate<T> suffix() {
        this.suffix = true;
        return this;
    }
}

