/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.minio;

import cn.hiboot.mcn.autoconfigure.minio.MinioException;
import cn.hiboot.mcn.autoconfigure.minio.MinioProperties;
import cn.hiboot.mcn.autoconfigure.minio.PreSignResult;
import cn.hiboot.mcn.core.task.TaskThreadPool;
import cn.hiboot.mcn.core.util.McnUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.MinioAsyncClient;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMinioClient
extends MinioAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMinioClient.class);
    private long size;
    private static final int MAX_PART = 10000;
    private OkHttpClient okHttpClient;
    private TaskThreadPool pool;
    private int expire;
    private Method method;
    private MinioProperties minioProperties;

    public DefaultMinioClient(MinioProperties minioProperties, MinioAsyncClient.Builder builder) {
        this(builder.credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).endpoint(minioProperties.getEndpoint()).httpClient(minioProperties.getClient().okHttpClient()).build());
        this.minioProperties = minioProperties;
        this.okHttpClient = minioProperties.getClient().okHttpClient();
        this.pool = new TaskThreadPool(minioProperties.getPool().getCore(), minioProperties.getPool().getMax(), minioProperties.getPool().getQueueSize(), minioProperties.getPool().getThreadName());
        this.size = minioProperties.getMinMultipartSize().toBytes();
        this.expire = minioProperties.getExpire();
        this.method = Method.valueOf((String)minioProperties.getMethod());
    }

    private DefaultMinioClient(MinioAsyncClient client) {
        super(client);
    }

    public MinioProperties getConfig() {
        return this.minioProperties;
    }

    public void upload(String bucketName, String objectName, long length, String contentType, InputStream inputStream) throws Exception {
        int c;
        int intSize = (int)this.size;
        int count = (int)(length / this.size + 1L);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(intSize);
        byte[] d = new byte[intSize];
        PreSignResult preSignResult = this.getPresignedObjectUrl(bucketName, objectName, contentType, count);
        int index = 0;
        while ((c = inputStream.read(d)) != -1) {
            outputStream.reset();
            outputStream.write(d, 0, c);
            byte[] bytes = outputStream.toByteArray();
            String url = preSignResult.getUploadUrls().get(index++);
            this.pool.execute(() -> this.upload(url, contentType, bytes));
        }
        this.pool.closeUntilAllTaskFinish();
        this.mergeMultipartUpload(bucketName, objectName, preSignResult.getUploadId());
    }

    private void upload(String url, String contentType, byte[] data) {
        try {
            this.okHttpClient.newCall(new Request.Builder().url(url).put(RequestBody.create((MediaType)MediaType.parse((String)this.getOrDefault(contentType)), (byte[])data)).build()).execute();
        }
        catch (IOException e) {
            log.error("async upload failed {}", (Object)e.getMessage());
        }
    }

    private String getOrDefault(String contentType) {
        if (McnUtils.isNullOrEmpty((Object)contentType)) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    public PreSignResult getPresignedObjectUrl(String bucketName, String objectName, String contentType, int count) throws Exception {
        HashMultimap headers = HashMultimap.create();
        headers.put((Object)"Content-Type", (Object)this.getOrDefault(contentType));
        PreSignResult preSignResult = new PreSignResult(count);
        if (count == 1) {
            preSignResult.getUploadUrls().add(this.getPresignedObjectUrl(bucketName, objectName, null));
        } else {
            CreateMultipartUploadResponse response = (CreateMultipartUploadResponse)this.createMultipartUploadAsync(bucketName, this.region, objectName, (Multimap)headers, null).get();
            String uploadId = response.result().uploadId();
            HashMap<String, String> reqParams = new HashMap<String, String>();
            reqParams.put("uploadId", uploadId);
            preSignResult.setUploadId(uploadId);
            for (int i = 1; i <= count; ++i) {
                reqParams.put("partNumber", String.valueOf(i));
                preSignResult.getUploadUrls().add(this.getPresignedObjectUrl(bucketName, objectName, reqParams));
            }
        }
        return preSignResult;
    }

    private String getPresignedObjectUrl(String bucketName, String objectName, Map<String, String> queryParams) throws Exception {
        return this.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(this.method).bucket(bucketName)).object(objectName)).expiry(this.expire).extraQueryParams(queryParams)).build());
    }

    public void mergeMultipartUpload(String bucketName, String objectName, String uploadId) throws Exception {
        Part[] parts = new Part[10000];
        ListPartsResponse partResult = (ListPartsResponse)this.listPartsAsync(bucketName, null, objectName, 10000, 0, uploadId, null, null).get();
        int partNumber = 1;
        for (Part part : partResult.result().partList()) {
            parts[partNumber - 1] = new Part(partNumber, part.etag());
            ++partNumber;
        }
        if (partNumber == 1) {
            throw new MinioException("\u672a\u627e\u5230\u9700\u8981\u5408\u5e76\u7684\u5757");
        }
        this.completeMultipartUploadAsync(bucketName, this.region, objectName, uploadId, parts, null, null).get();
    }
}

