/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.minio;

import cn.hiboot.mcn.autoconfigure.minio.BucketItem;
import cn.hiboot.mcn.autoconfigure.minio.DefaultMinioClient;
import cn.hiboot.mcn.autoconfigure.minio.MinioException;
import cn.hiboot.mcn.autoconfigure.minio.PreSignResult;
import cn.hiboot.mcn.core.util.McnUtils;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Minio {
    public static final Logger log = LoggerFactory.getLogger(Minio.class);
    public static final Map<String, String> map = Collections.singletonMap("Expect", "100-continue");

    public DefaultMinioClient getMinioClient();

    default public String getDefaultBucketName() {
        return this.getMinioClient().getConfig().getDefaultBucketName();
    }

    default public String getOrDefaultBucket(String bucketName) {
        if (McnUtils.isNullOrEmpty((Object)bucketName)) {
            bucketName = this.getDefaultBucketName();
        }
        if (McnUtils.isNullOrEmpty((Object)bucketName)) {
            throw new MinioException(bucketName + " must not be null or empty");
        }
        return bucketName;
    }

    default public void upload(String objectName, long objectSize, InputStream stream) {
        this.upload(objectName, objectSize, null, stream);
    }

    default public void upload(String objectName, long objectSize, String contentType, InputStream stream) {
        this.upload(null, objectName, objectSize, 0L, contentType, stream);
    }

    default public void upload(String bucketName, String objectName, long objectSize, long partSize, String contentType, InputStream stream) {
        bucketName = this.getOrDefaultBucket(bucketName);
        DefaultMinioClient minioClient = this.getMinioClient();
        if (partSize == 0L) {
            partSize = minioClient.getConfig().getMinMultipartSize().toBytes();
        }
        try {
            PutObjectArgs.Builder builder = ((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).headers(map)).stream(stream, objectSize, partSize);
            if (McnUtils.isNotNullAndEmpty((Object)contentType)) {
                builder.contentType(contentType);
            }
            minioClient.putObject((PutObjectArgs)builder.build()).get();
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public void uploadParallel(String objectName, long objectSize, InputStream stream) {
        this.uploadParallel(objectName, objectSize, null, stream);
    }

    default public void uploadParallel(String objectName, long objectSize, String contentType, InputStream stream) {
        this.uploadParallel(null, objectName, objectSize, contentType, stream);
    }

    default public void uploadParallel(String bucketName, String objectName, long objectSize, String contentType, InputStream stream) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            this.getMinioClient().upload(bucketName, objectName, objectSize, contentType, stream);
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public PreSignResult getPresignedObjectUrl(String objectName, int count) {
        return this.getPresignedObjectUrl(null, objectName, null, count);
    }

    default public PreSignResult getPresignedObjectUrl(String objectName, String contentType, int count) {
        return this.getPresignedObjectUrl(null, objectName, contentType, count);
    }

    default public PreSignResult getPresignedObjectUrl(String bucketName, String objectName, String contentType, int count) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            return this.getMinioClient().getPresignedObjectUrl(bucketName, objectName, contentType, count);
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public void mergeMultipartUpload(String objectName, String uploadId) {
        this.mergeMultipartUpload(null, objectName, uploadId);
    }

    default public void mergeMultipartUpload(String bucketName, String objectName, String uploadId) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            this.getMinioClient().mergeMultipartUpload(bucketName, objectName, uploadId);
        }
        catch (MinioException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public void delete(String objectName) {
        this.delete(null, objectName);
    }

    default public void delete(String bucketName, String objectName) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            RemoveObjectArgs args = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
            this.getMinioClient().removeObject(args).get();
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public List<Item> listObjects() {
        return this.listObjects(null, false);
    }

    default public List<Item> listObjects(boolean recursive) {
        return this.listObjects(null, recursive);
    }

    default public List<Item> listObjects(String bucketName) {
        return this.listObjects(bucketName, false);
    }

    default public List<Item> listObjects(String bucketName, boolean recursive) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).recursive(recursive).build();
            Iterable list = this.getMinioClient().listObjects(args);
            return StreamSupport.stream(list.spliterator(), true).map(r -> {
                try {
                    return (Item)r.get();
                }
                catch (Exception exception) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public void deleteAll() {
        this.deleteAll(null);
    }

    default public void deleteAll(String bucketName) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).recursive(true).build();
            Iterable list = this.getMinioClient().listObjects(args);
            List objectList = StreamSupport.stream(list.spliterator(), true).map(r -> {
                try {
                    return new DeleteObject(((Item)r.get()).objectName());
                }
                catch (Exception exception) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            for (Result errorResult : this.getMinioClient().removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(objectList).build())) {
                DeleteError error = (DeleteError)errorResult.get();
                log.error("Error delete object {} ; Reason is {}", (Object)error.objectName(), (Object)error.message());
            }
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public InputStream getObject(String objectName) {
        return this.getObject(null, objectName);
    }

    default public InputStream getObject(String bucketName, String objectName) {
        bucketName = this.getOrDefaultBucket(bucketName);
        try {
            GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
            return (InputStream)this.getMinioClient().getObject(args).get();
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public boolean buckExist(String bucketName) {
        try {
            return (Boolean)this.getMinioClient().bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build()).get();
        }
        catch (Exception e) {
            log.error("check buck exist error : {}", (Object)e.getMessage());
            return false;
        }
    }

    default public void createBucket(String bucketName) {
        if (this.buckExist(bucketName)) {
            return;
        }
        try {
            MakeBucketArgs args = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build();
            this.getMinioClient().makeBucket(args).get();
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }

    default public List<BucketItem> listBuckets() {
        try {
            List buckets = (List)this.getMinioClient().listBuckets().get();
            if (McnUtils.isNotNullAndEmpty((Object)buckets)) {
                return buckets.stream().map(b -> new BucketItem(b.name(), b.creationDate())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
        return Collections.emptyList();
    }

    default public void deleteBucket(String bucketName) {
        try {
            RemoveBucketArgs args = (RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build();
            this.getMinioClient().removeBucket(args).get();
        }
        catch (Exception e) {
            throw new MinioException(e);
        }
    }
}

