/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.minio;

import cn.hiboot.mcn.autoconfigure.minio.DefaultMinio;
import cn.hiboot.mcn.autoconfigure.minio.DefaultMinioClient;
import cn.hiboot.mcn.autoconfigure.minio.Minio;
import cn.hiboot.mcn.autoconfigure.minio.MinioClientBuilderCustomizer;
import cn.hiboot.mcn.autoconfigure.minio.MinioProperties;
import io.minio.MinioAsyncClient;
import io.minio.MinioClient;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

@AutoConfiguration
@ConditionalOnClass(value={MinioClient.class})
@EnableConfigurationProperties(value={MinioProperties.class})
public class MinioAutoConfiguration {
    private final MinioProperties config;
    private final ObjectProvider<MinioClientBuilderCustomizer> customizers;

    public MinioAutoConfiguration(MinioProperties config, ObjectProvider<MinioClientBuilderCustomizer> customizers) {
        this.config = config;
        this.customizers = customizers;
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultMinioClient minioClient() {
        MinioAsyncClient.Builder builder = MinioAsyncClient.builder();
        for (MinioClientBuilderCustomizer customizer : this.customizers) {
            customizer.customize(builder);
        }
        return new DefaultMinioClient(this.config, builder);
    }

    @Bean
    @ConditionalOnMissingBean
    public Minio minio(DefaultMinioClient minioClient) {
        return new DefaultMinio(minioClient);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnBean(value={DispatcherServlet.class})
    private static class PreviewImage {
        @Autowired
        private Minio minio;

        private PreviewImage() {
        }

        @Bean
        public SimpleUrlHandlerMapping simpleUrlHandlerMapping() {
            return new SimpleUrlHandlerMapping(Collections.singletonMap("_imagePreview", new PreviewImageRequestHandler(this.minio)), 0x7FFFFFFD);
        }

        private static class PreviewImageRequestHandler
        implements HttpRequestHandler {
            private final Minio minio;

            public PreviewImageRequestHandler(Minio minio) {
                this.minio = minio;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                OutputStream os = null;
                try {
                    BufferedImage image = ImageIO.read(this.minio.getObject(request.getParameter(this.minio.getMinioClient().getConfig().getPreviewImageParameterName())));
                    response.setContentType("image/png");
                    os = response.getOutputStream();
                    if (image != null) {
                        ImageIO.write((RenderedImage)image, "png", os);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (os != null) {
                        os.flush();
                        os.close();
                    }
                }
            }
        }
    }
}

