/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.minio;

import io.minio.http.HttpUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="minio")
public class MinioProperties {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(10L);
    private String endpoint;
    private String accessKey;
    private String secretKey;
    private String defaultBucketName;
    private String previewImageParameterName = "image";
    private DataSize minMultipartSize = DataSize.ofMegabytes((long)10L);
    private int expire = (int)TimeUnit.HOURS.toSeconds(6L);
    private String method = "PUT";
    private Pool pool = new Pool();
    private Client client = new Client();

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public void setDefaultBucketName(String defaultBucketName) {
        this.defaultBucketName = defaultBucketName;
    }

    public String getPreviewImageParameterName() {
        return this.previewImageParameterName;
    }

    public void setPreviewImageParameterName(String previewImageParameterName) {
        this.previewImageParameterName = previewImageParameterName;
    }

    public DataSize getMinMultipartSize() {
        return this.minMultipartSize;
    }

    public void setMinMultipartSize(DataSize minMultipartSize) {
        this.minMultipartSize = minMultipartSize;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_TIMEOUT;
    }

    public static class Client {
        private Duration connectTimeout = MinioProperties.access$000();
        private Duration readTimeout = MinioProperties.access$000();
        private Duration writeTimeout = MinioProperties.access$000();

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Duration getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public OkHttpClient okHttpClient() {
            return HttpUtils.newDefaultHttpClient((long)this.getConnectTimeout().toMillis(), (long)this.getWriteTimeout().toMillis(), (long)this.getReadTimeout().toMillis());
        }
    }

    public static class Pool {
        private static final int DEFAULT_SIZE = Runtime.getRuntime().availableProcessors();
        private Integer core = DEFAULT_SIZE;
        private Integer max = DEFAULT_SIZE;
        private int queueSize = 10;
        private String threadName = "Upload";

        public int getCore() {
            return this.core;
        }

        public void setCore(int core) {
            this.core = core;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }
    }
}

