/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.mongo;

import cn.hiboot.mcn.autoconfigure.mongo.MongoExtensionProperties;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={MongoExtensionProperties.class})
@ConditionalOnClass(value={MongoClient.class})
@ConditionalOnMissingBean(type={"org.springframework.data.mongodb.MongoDatabaseFactory"})
public class MongoExtensionAutoConfiguration {
    private static final Map<String, ReadConcern> NAMED_CONCERNS = new HashMap<String, ReadConcern>();

    @Bean
    MongoClientSettingsBuilderCustomizer defaultMongoClientSettingsBuilderCustomizer(MongoExtensionProperties mongo) {
        return builder -> {
            builder.applyToConnectionPoolSettings(connectionPool -> {
                connectionPool.maxSize(mongo.getPool().getMaxSize());
                connectionPool.minSize(mongo.getPool().getMinSize());
                connectionPool.maxWaitTime(mongo.getPool().getMaxWaitTime(), TimeUnit.MILLISECONDS);
            });
            builder.readPreference(ReadPreference.valueOf((String)mongo.getReadPreference().name()));
            builder.writeConcern(WriteConcern.valueOf((String)mongo.getWriteConcern().name()));
            builder.readConcern(Objects.isNull((Object)mongo.getReadConcern()) ? ReadConcern.DEFAULT : NAMED_CONCERNS.get(mongo.getReadConcern().name()));
            builder.applyToSocketSettings(socket -> {
                socket.connectTimeout(mongo.getSocket().getConnectTimeout(), TimeUnit.MILLISECONDS);
                socket.readTimeout(mongo.getSocket().getReadTimeout(), TimeUnit.MILLISECONDS);
            });
            if (mongo.isAutoPojo()) {
                builder.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})}));
            }
        };
    }

    static {
        for (Field f : ReadConcern.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(ReadConcern.class)) continue;
            String key = f.getName().toLowerCase();
            try {
                NAMED_CONCERNS.put(key, (ReadConcern)f.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

