/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.mybatis;

import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceConfig;
import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
public class MybatisExtensionAutoConfiguration
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
Ordered {
    private static final String STANDARD_SQL_SESSION_FACTORY_BEAN_NAME = "sqlSessionFactory";
    private static final String STANDARD_SQL_SESSION_TEMPLATE_BEAN_NAME = "sqlSessionTemplate";
    private Environment environment;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String name = MapperScannerConfigurer.class.getName();
        if (registry.containsBeanDefinition(name)) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(name);
            beanDefinition.getPropertyValues().removePropertyValue("annotationClass");
            String daoPackageName = this.environment.getProperty("dao.package.name", "dao");
            String toScanPkg = this.environment.getProperty("app.base-package") + "." + daoPackageName;
            String additionalPkg = this.environment.getProperty("mapper.scan.additional-package", "");
            if (StringUtils.hasText((String)additionalPkg)) {
                toScanPkg = toScanPkg + "," + additionalPkg;
            }
            beanDefinition.getPropertyValues().addPropertyValue("basePackage", (Object)toScanPkg);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        MultipleDataSourceConfig multipleDataSourceConfig = (MultipleDataSourceConfig)beanFactory.getBean(MultipleDataSourceConfig.class);
        Map<String, DataSourceProperties> properties = multipleDataSourceConfig.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        if (beanFactory.containsBean(STANDARD_SQL_SESSION_FACTORY_BEAN_NAME)) {
            beanFactory.getBeanDefinition(STANDARD_SQL_SESSION_FACTORY_BEAN_NAME).setPrimary(true);
        }
        if (beanFactory.containsBean(STANDARD_SQL_SESSION_TEMPLATE_BEAN_NAME)) {
            beanFactory.getBeanDefinition(STANDARD_SQL_SESSION_TEMPLATE_BEAN_NAME).setPrimary(true);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return 0;
    }
}

