/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.autoconfigure.mybatis;

import cn.hiboot.mcn.autoconfigure.config.ConfigProperties;
import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceAutoConfiguration;
import cn.hiboot.mcn.autoconfigure.jdbc.MultipleDataSourceConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.FullyQualifiedAnnotationBeanNameGenerator;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;

@AutoConfiguration(after={MultipleDataSourceAutoConfiguration.class, MybatisAutoConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, HikariDataSource.class})
@ConditionalOnProperty(prefix="mybatis.multiple.datasource", name={"enable"}, havingValue="true")
@ConditionalOnBean(value={MultipleDataSourceConfig.class})
@Import(value={MybatisMultipleDataSourceConfig.class})
public class MybatisMultipleDataSourceAutoConfiguration {

    protected static class MybatisMultipleDataSourceConfig
    implements ImportBeanDefinitionRegistrar {
        private final ResourceLoader resourceLoader;
        private final String basePackage;
        private final MultipleDataSourceConfig multipleDataSourceConfig;

        public MybatisMultipleDataSourceConfig(ResourceLoader resourceLoader, BeanFactory beanFactory) {
            this.resourceLoader = resourceLoader;
            this.multipleDataSourceConfig = (MultipleDataSourceConfig)beanFactory.getBean(MultipleDataSourceConfig.class);
            this.basePackage = this.multipleDataSourceConfig.getBasePackage();
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
            this.multipleDataSourceConfig.getProperties().forEach((arg_0, arg_1) -> this.lambda$registerBeanDefinitions$0(registry, (ResourcePatternResolver)pathResolver, arg_0, arg_1));
        }

        private BeanDefinition buildDefinition(ResourcePatternResolver pathResolver, String dsName) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SqlSessionFactoryBean.class);
            Resource[] resources = this.getResources(pathResolver, dsName);
            if (resources != null) {
                beanDefinitionBuilder.addPropertyValue("mapperLocations", (Object)resources);
            }
            Configuration conf = new Configuration();
            conf.setMapUnderscoreToCamelCase(true);
            beanDefinitionBuilder.addPropertyValue("dataSource", (Object)new RuntimeBeanReference(ConfigProperties.getDataSourceBeanName(dsName))).addPropertyValue("vfs", SpringBootVFS.class).addPropertyValue("typeAliasesPackage", (Object)(this.basePackage + ".bean." + dsName)).addPropertyValue("typeHandlersPackage", (Object)(this.basePackage + "." + this.multipleDataSourceConfig.getDaoPackageName() + ".handler." + dsName)).addPropertyValue("configuration", (Object)conf);
            return beanDefinitionBuilder.getBeanDefinition();
        }

        private Resource[] getResources(ResourcePatternResolver pathResolver, String dsName) {
            try {
                return pathResolver.getResources("classpath:mapper/" + dsName + "/*.xml");
            }
            catch (IOException e) {
                return null;
            }
        }

        private void scanMapper(BeanDefinitionRegistry registry, String sqlSessionFactoryName, String pkg) {
            ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
            if (this.resourceLoader != null) {
                scanner.setResourceLoader(this.resourceLoader);
            }
            scanner.setBeanNameGenerator((BeanNameGenerator)FullyQualifiedAnnotationBeanNameGenerator.INSTANCE);
            scanner.setSqlSessionFactoryBeanName(sqlSessionFactoryName);
            scanner.registerFilters();
            scanner.doScan(new String[]{pkg});
        }

        private /* synthetic */ void lambda$registerBeanDefinitions$0(BeanDefinitionRegistry registry, ResourcePatternResolver pathResolver, String dsName, DataSourceProperties ds) {
            String sqlSessionFactoryName = dsName + "SqlSessionFactory";
            this.scanMapper(registry, sqlSessionFactoryName, this.basePackage + "." + this.multipleDataSourceConfig.getDaoPackageName() + "." + dsName);
            registry.registerBeanDefinition(dsName + "SqlSessionTemplate", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SqlSessionTemplate.class).addConstructorArgReference(sqlSessionFactoryName).getBeanDefinition());
            registry.registerBeanDefinition(sqlSessionFactoryName, this.buildDefinition(pathResolver, dsName));
        }
    }
}

